/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.nativebinaries.BuildType;
import org.gradle.nativebinaries.Flavor;
import org.gradle.nativebinaries.NativeLibrary;
import org.gradle.nativebinaries.internal.AbstractProjectNativeLibraryBinary;
import org.gradle.nativebinaries.internal.StaticLibraryBinaryInternal;
import org.gradle.nativebinaries.internal.resolve.NativeDependencyResolver;
import org.gradle.nativebinaries.platform.Platform;
import org.gradle.nativebinaries.toolchain.internal.ToolChainInternal;
import org.gradle.runtime.base.internal.BinaryNamingScheme;

public class ProjectStaticLibraryBinary
extends AbstractProjectNativeLibraryBinary
implements StaticLibraryBinaryInternal {
    private final List<FileCollection> additionalLinkFiles = new ArrayList<FileCollection>();
    private File staticLibraryFile;

    public ProjectStaticLibraryBinary(NativeLibrary library, Flavor flavor, ToolChainInternal toolChain, Platform platform, BuildType buildType, BinaryNamingScheme namingScheme, NativeDependencyResolver resolver) {
        super(library, flavor, toolChain, platform, buildType, namingScheme, resolver);
    }

    public File getStaticLibraryFile() {
        return this.staticLibraryFile;
    }

    public void setStaticLibraryFile(File staticLibraryFile) {
        this.staticLibraryFile = staticLibraryFile;
    }

    public File getPrimaryOutput() {
        return this.getStaticLibraryFile();
    }

    public void additionalLinkFiles(FileCollection files) {
        this.additionalLinkFiles.add(files);
    }

    public FileCollection getLinkFiles() {
        return new StaticLibraryLinkOutputs();
    }

    public FileCollection getRuntimeFiles() {
        return new SimpleFileCollection(new File[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StaticLibraryLinkOutputs
    extends AbstractProjectNativeLibraryBinary.LibraryOutputs {
        private StaticLibraryLinkOutputs() {
        }

        @Override
        protected boolean hasOutputs() {
            return ProjectStaticLibraryBinary.this.hasSources() || !ProjectStaticLibraryBinary.this.additionalLinkFiles.isEmpty();
        }

        @Override
        protected Set<File> getOutputs() {
            LinkedHashSet<File> allFiles = new LinkedHashSet<File>();
            if (ProjectStaticLibraryBinary.this.hasSources()) {
                allFiles.add(ProjectStaticLibraryBinary.this.getStaticLibraryFile());
            }
            for (FileCollection resourceSet : ProjectStaticLibraryBinary.this.additionalLinkFiles) {
                allFiles.addAll(resourceSet.getFiles());
            }
            return allFiles;
        }
    }
}

