/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.rc.WindowsResourceSet;
import org.gradle.nativebinaries.BuildType;
import org.gradle.nativebinaries.Flavor;
import org.gradle.nativebinaries.NativeLibrary;
import org.gradle.nativebinaries.SharedLibraryBinary;
import org.gradle.nativebinaries.internal.AbstractProjectNativeLibraryBinary;
import org.gradle.nativebinaries.internal.resolve.NativeDependencyResolver;
import org.gradle.nativebinaries.platform.Platform;
import org.gradle.nativebinaries.toolchain.internal.ToolChainInternal;
import org.gradle.runtime.base.internal.BinaryNamingScheme;

public class ProjectSharedLibraryBinary
extends AbstractProjectNativeLibraryBinary
implements SharedLibraryBinary {
    private File sharedLibraryFile;
    private File sharedLibraryLinkFile;

    public ProjectSharedLibraryBinary(NativeLibrary library, Flavor flavor, ToolChainInternal toolChain, Platform platform, BuildType buildType, BinaryNamingScheme namingScheme, NativeDependencyResolver resolver) {
        super(library, flavor, toolChain, platform, buildType, namingScheme, resolver);
    }

    public File getSharedLibraryFile() {
        return this.sharedLibraryFile;
    }

    public void setSharedLibraryFile(File sharedLibraryFile) {
        this.sharedLibraryFile = sharedLibraryFile;
    }

    public File getSharedLibraryLinkFile() {
        return this.sharedLibraryLinkFile;
    }

    public void setSharedLibraryLinkFile(File sharedLibraryLinkFile) {
        this.sharedLibraryLinkFile = sharedLibraryLinkFile;
    }

    public File getPrimaryOutput() {
        return this.getSharedLibraryFile();
    }

    public FileCollection getLinkFiles() {
        return new SharedLibraryLinkOutputs();
    }

    public FileCollection getRuntimeFiles() {
        return new SharedLibraryRuntimeOutputs();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SharedLibraryRuntimeOutputs
    extends AbstractProjectNativeLibraryBinary.LibraryOutputs {
        private SharedLibraryRuntimeOutputs() {
        }

        @Override
        protected boolean hasOutputs() {
            return ProjectSharedLibraryBinary.this.hasSources();
        }

        @Override
        protected Set<File> getOutputs() {
            return Collections.singleton(ProjectSharedLibraryBinary.this.getSharedLibraryFile());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SharedLibraryLinkOutputs
    extends AbstractProjectNativeLibraryBinary.LibraryOutputs {
        private SharedLibraryLinkOutputs() {
        }

        @Override
        protected boolean hasOutputs() {
            return ProjectSharedLibraryBinary.this.hasSources() && !this.isResourceOnly();
        }

        @Override
        protected Set<File> getOutputs() {
            return Collections.singleton(ProjectSharedLibraryBinary.this.getSharedLibraryLinkFile());
        }

        private boolean isResourceOnly() {
            return this.hasResources() && !this.hasExportedSymbols();
        }

        private boolean hasResources() {
            for (WindowsResourceSet windowsResourceSet : ProjectSharedLibraryBinary.this.getSource().withType(WindowsResourceSet.class)) {
                if (windowsResourceSet.getSource().isEmpty()) continue;
                return true;
            }
            return false;
        }

        private boolean hasExportedSymbols() {
            for (LanguageSourceSet languageSourceSet : ProjectSharedLibraryBinary.this.getSource()) {
                if (languageSourceSet instanceof WindowsResourceSet || languageSourceSet.getSource().isEmpty()) continue;
                return true;
            }
            return false;
        }
    }
}

