/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal;

import org.gradle.api.DomainObjectSet;
import org.gradle.api.Task;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.nativebinaries.NativeBinaryTasks;
import org.gradle.nativebinaries.internal.ProjectNativeBinaryInternal;
import org.gradle.nativebinaries.tasks.AbstractLinkTask;
import org.gradle.nativebinaries.tasks.CreateStaticLibrary;
import org.gradle.nativebinaries.tasks.ObjectFilesToBinary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNativeBinaryTasks
extends DefaultDomainObjectSet<Task>
implements NativeBinaryTasks {
    private final ProjectNativeBinaryInternal binary;

    public DefaultNativeBinaryTasks(ProjectNativeBinaryInternal binary) {
        super(Task.class);
        this.binary = binary;
    }

    @Override
    public Task getBuild() {
        return this.binary.getBuildTask();
    }

    @Override
    public AbstractLinkTask getLink() {
        return this.findOnlyWithType(AbstractLinkTask.class);
    }

    @Override
    public CreateStaticLibrary getCreateStaticLib() {
        return this.findOnlyWithType(CreateStaticLibrary.class);
    }

    @Override
    public ObjectFilesToBinary getCreateOrLink() {
        AbstractLinkTask link = this.getLink();
        return link == null ? this.getCreateStaticLib() : link;
    }

    private <T extends Task> T findOnlyWithType(Class<T> type) {
        DomainObjectSet tasks = this.withType(type);
        if (tasks.size() == 0) {
            return null;
        }
        if (tasks.size() > 1) {
            throw new UnknownDomainObjectException(String.format("Multiple task with type '%s' found", type.getSimpleName()));
        }
        return (T)((Task)tasks.iterator().next());
    }
}

