/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal;

import java.util.Collection;
import java.util.Set;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.nativebinaries.NativeBinary;
import org.gradle.nativebinaries.internal.ProjectNativeComponentIdentifier;
import org.gradle.nativebinaries.internal.ProjectNativeComponentInternal;
import org.gradle.nativebinaries.internal.SourceSetNotationParser;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectNativeComponent
implements ProjectNativeComponentInternal {
    private final NotationParser<Object, Set<LanguageSourceSet>> sourcesNotationParser = SourceSetNotationParser.parser();
    private final ProjectNativeComponentIdentifier id;
    private final DomainObjectSet<LanguageSourceSet> sourceSets;
    private final DefaultDomainObjectSet<NativeBinary> binaries;
    private String baseName;

    public AbstractProjectNativeComponent(ProjectNativeComponentIdentifier id) {
        this.id = id;
        this.sourceSets = new DefaultDomainObjectSet(LanguageSourceSet.class);
        this.binaries = new DefaultDomainObjectSet(NativeBinary.class);
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String getProjectPath() {
        return this.id.getProjectPath();
    }

    public String getName() {
        return this.id.getName();
    }

    @Override
    public DomainObjectSet<LanguageSourceSet> getSource() {
        return this.sourceSets;
    }

    @Override
    public void source(Object sources) {
        this.sourceSets.addAll((Collection)this.sourcesNotationParser.parseNotation(sources));
    }

    @Override
    public DomainObjectSet<NativeBinary> getBinaries() {
        return this.binaries;
    }

    @Override
    public String getBaseName() {
        return (String)GUtil.elvis((Object)this.baseName, (Object)this.getName());
    }

    @Override
    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }
}

