/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.language.DependentSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.nativebinaries.BuildType;
import org.gradle.nativebinaries.Flavor;
import org.gradle.nativebinaries.NativeBinaryTasks;
import org.gradle.nativebinaries.NativeDependencySet;
import org.gradle.nativebinaries.NativeLibraryBinary;
import org.gradle.nativebinaries.ProjectNativeComponent;
import org.gradle.nativebinaries.Tool;
import org.gradle.nativebinaries.internal.DefaultNativeBinaryTasks;
import org.gradle.nativebinaries.internal.DefaultTool;
import org.gradle.nativebinaries.internal.ProjectNativeBinaryInternal;
import org.gradle.nativebinaries.internal.SourceSetNotationParser;
import org.gradle.nativebinaries.internal.resolve.NativeBinaryResolveResult;
import org.gradle.nativebinaries.internal.resolve.NativeDependencyResolver;
import org.gradle.nativebinaries.platform.Platform;
import org.gradle.nativebinaries.toolchain.internal.ToolChainInternal;
import org.gradle.runtime.base.internal.AbstractBuildableModelElement;
import org.gradle.runtime.base.internal.BinaryNamingScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectNativeBinary
extends AbstractBuildableModelElement
implements ProjectNativeBinaryInternal {
    private final ProjectNativeComponent component;
    private final NotationParser<Object, Set<LanguageSourceSet>> sourcesNotationParser = SourceSetNotationParser.parser();
    private final Set<? super Object> libs = new LinkedHashSet<Object>();
    private final DomainObjectSet<LanguageSourceSet> source = new DefaultDomainObjectSet(LanguageSourceSet.class);
    private final DefaultTool linker = new DefaultTool();
    private final DefaultTool staticLibArchiver = new DefaultTool();
    private final NativeBinaryTasks tasks = new DefaultNativeBinaryTasks(this);
    private final BinaryNamingScheme namingScheme;
    private final Flavor flavor;
    private final ToolChainInternal toolChain;
    private final Platform targetPlatform;
    private final BuildType buildType;
    private final NativeDependencyResolver resolver;
    private boolean buildable;

    protected AbstractProjectNativeBinary(ProjectNativeComponent owner, Flavor flavor, ToolChainInternal toolChain, Platform targetPlatform, BuildType buildType, BinaryNamingScheme namingScheme, NativeDependencyResolver resolver) {
        this.component = owner;
        this.namingScheme = namingScheme;
        this.flavor = flavor;
        this.toolChain = toolChain;
        this.targetPlatform = targetPlatform;
        this.buildType = buildType;
        this.buildable = true;
        this.resolver = resolver;
        owner.getSource().all((Action)new Action<LanguageSourceSet>(){

            public void execute(LanguageSourceSet sourceSet) {
                AbstractProjectNativeBinary.this.source.add((Object)sourceSet);
            }
        });
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return this.namingScheme.getDescription();
    }

    public String getName() {
        return this.namingScheme.getLifecycleTaskName();
    }

    @Override
    public ProjectNativeComponent getComponent() {
        return this.component;
    }

    @Override
    public Flavor getFlavor() {
        return this.flavor;
    }

    @Override
    public ToolChainInternal getToolChain() {
        return this.toolChain;
    }

    @Override
    public Platform getTargetPlatform() {
        return this.targetPlatform;
    }

    @Override
    public BuildType getBuildType() {
        return this.buildType;
    }

    @Override
    public DomainObjectSet<LanguageSourceSet> getSource() {
        return this.source;
    }

    @Override
    public void source(Object sources) {
        this.source.addAll((Collection)this.sourcesNotationParser.parseNotation(sources));
    }

    @Override
    public Tool getLinker() {
        return this.linker;
    }

    @Override
    public Tool getStaticLibArchiver() {
        return this.staticLibArchiver;
    }

    @Override
    public NativeBinaryTasks getTasks() {
        return this.tasks;
    }

    public BinaryNamingScheme getNamingScheme() {
        return this.namingScheme;
    }

    @Override
    public Collection<NativeDependencySet> getLibs() {
        return this.resolve((Collection<? extends DependentSourceSet>)this.source.withType(DependentSourceSet.class)).getAllResults();
    }

    @Override
    public Collection<NativeDependencySet> getLibs(DependentSourceSet sourceSet) {
        return this.resolve(Collections.singleton(sourceSet)).getAllResults();
    }

    @Override
    public void lib(Object notation) {
        this.libs.add(notation);
    }

    @Override
    public Collection<NativeLibraryBinary> getDependentBinaries() {
        return this.resolve((Collection<? extends DependentSourceSet>)this.source.withType(DependentSourceSet.class)).getAllLibraryBinaries();
    }

    private NativeBinaryResolveResult resolve(Collection<? extends DependentSourceSet> sourceSets) {
        LinkedHashSet<? super Object> allLibs = new LinkedHashSet<Object>(this.libs);
        for (DependentSourceSet dependentSourceSet : sourceSets) {
            allLibs.addAll(dependentSourceSet.getLibs());
        }
        NativeBinaryResolveResult resolution = new NativeBinaryResolveResult(this, allLibs);
        this.resolver.resolve(resolution);
        return resolution;
    }

    public boolean isBuildable() {
        return this.buildable;
    }

    @Override
    public void setBuildable(boolean buildable) {
        this.buildable = buildable;
    }
}

