/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal.rules;

import org.gradle.api.Task;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.ide.visualstudio.VisualStudioExtension;
import org.gradle.ide.visualstudio.VisualStudioProject;
import org.gradle.ide.visualstudio.VisualStudioSolution;
import org.gradle.ide.visualstudio.tasks.GenerateFiltersFileTask;
import org.gradle.ide.visualstudio.tasks.GenerateProjectFileTask;
import org.gradle.ide.visualstudio.tasks.GenerateSolutionFileTask;
import org.gradle.model.ModelRule;
import org.gradle.nativebinaries.ProjectNativeComponent;

public class CreateVisualStudioTasks
extends ModelRule {
    public void createTasksForVisualStudio(TaskContainer tasks, VisualStudioExtension visualStudioExtension) {
        for (VisualStudioProject vsProject : visualStudioExtension.getProjects()) {
            vsProject.builtBy(new Object[]{this.createProjectsFileTask(tasks, vsProject)});
            vsProject.builtBy(new Object[]{this.createFiltersFileTask(tasks, vsProject)});
        }
        for (VisualStudioSolution vsSolution : visualStudioExtension.getSolutions()) {
            Task solutionTask = tasks.create(vsSolution.getName() + "VisualStudio");
            solutionTask.setDescription(String.format("Generates the '%s' Visual Studio solution file.", vsSolution.getName()));
            vsSolution.setBuildTask(solutionTask);
            vsSolution.builtBy(new Object[]{this.createSolutionTask(tasks, vsSolution)});
            ProjectNativeComponent component = vsSolution.getComponent();
            Task lifecycleTask = (Task)tasks.maybeCreate(component.getName() + "VisualStudio");
            lifecycleTask.dependsOn(new Object[]{vsSolution});
            lifecycleTask.setGroup("IDE");
            lifecycleTask.setDescription(String.format("Generates the Visual Studio solution for %s.", component));
        }
        this.addCleanTask(tasks);
    }

    private void addCleanTask(TaskContainer tasks) {
        Delete cleanTask = (Delete)tasks.create("cleanVisualStudio", Delete.class);
        for (Task task : tasks.withType(GenerateSolutionFileTask.class)) {
            cleanTask.delete(new Object[]{task.getOutputs().getFiles()});
        }
        for (Task task : tasks.withType(GenerateFiltersFileTask.class)) {
            cleanTask.delete(new Object[]{task.getOutputs().getFiles()});
        }
        for (Task task : tasks.withType(GenerateProjectFileTask.class)) {
            cleanTask.delete(new Object[]{task.getOutputs().getFiles()});
        }
        cleanTask.setGroup("IDE");
        cleanTask.setDescription("Removes all generated Visual Studio project and solution files");
    }

    private Task createSolutionTask(TaskContainer tasks, VisualStudioSolution solution) {
        GenerateSolutionFileTask solutionFileTask = (GenerateSolutionFileTask)tasks.create(solution.getName() + "VisualStudioSolution", GenerateSolutionFileTask.class);
        solutionFileTask.setVisualStudioSolution(solution);
        return solutionFileTask;
    }

    private Task createProjectsFileTask(TaskContainer tasks, VisualStudioProject vsProject) {
        GenerateProjectFileTask task = (GenerateProjectFileTask)tasks.create(vsProject.getName() + "VisualStudioProject", GenerateProjectFileTask.class);
        task.setVisualStudioProject(vsProject);
        task.initGradleCommand();
        return task;
    }

    private Task createFiltersFileTask(TaskContainer tasks, VisualStudioProject vsProject) {
        GenerateFiltersFileTask task = (GenerateFiltersFileTask)tasks.create(vsProject.getName() + "VisualStudioFilters", GenerateFiltersFileTask.class);
        task.setVisualStudioProject(vsProject);
        return task;
    }
}

