/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioExtension;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectRegistry;
import org.gradle.nativebinaries.ProjectNativeBinary;
import org.gradle.nativebinaries.internal.ProjectNativeComponentInternal;
import org.gradle.nativebinaries.internal.resolve.ProjectLocator;

public class VisualStudioProjectResolver {
    private final ProjectLocator projectLocator;

    public VisualStudioProjectResolver(ProjectLocator projectLocator) {
        this.projectLocator = projectLocator;
    }

    public VisualStudioProjectConfiguration lookupProjectConfiguration(ProjectNativeBinary nativeBinary) {
        ProjectInternal componentProject = this.getComponentProject(nativeBinary);
        DefaultVisualStudioExtension visualStudioExtension = (DefaultVisualStudioExtension)componentProject.getModelRegistry().get("visualStudio", DefaultVisualStudioExtension.class);
        VisualStudioProjectRegistry projectRegistry = visualStudioExtension.getProjectRegistry();
        return projectRegistry.getProjectConfiguration(nativeBinary);
    }

    private ProjectInternal getComponentProject(ProjectNativeBinary nativeBinary) {
        String projectPath = ((ProjectNativeComponentInternal)nativeBinary.getComponent()).getProjectPath();
        return this.projectLocator.locateProject(projectPath);
    }
}

