/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.nativebinaries.NativeExecutableBinary;
import org.gradle.nativebinaries.NativeLibraryBinary;
import org.gradle.nativebinaries.ProjectNativeBinary;
import org.gradle.nativebinaries.SharedLibraryBinary;
import org.gradle.nativebinaries.internal.ProjectNativeBinaryInternal;
import org.gradle.nativebinaries.internal.ProjectNativeComponentInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualStudioProjectMapper {
    public ProjectConfigurationNames mapToConfiguration(ProjectNativeBinary nativeBinary) {
        String projectName = this.projectPrefix(nativeBinary) + this.componentName(nativeBinary) + this.projectSuffix(nativeBinary);
        String configurationName = this.getConfigurationName(nativeBinary);
        return new ProjectConfigurationNames(projectName, configurationName, "Win32");
    }

    private String getConfigurationName(ProjectNativeBinary nativeBinary) {
        List dimensions = ((ProjectNativeBinaryInternal)nativeBinary).getNamingScheme().getVariantDimensions();
        if (dimensions.isEmpty()) {
            return nativeBinary.getBuildType().getName();
        }
        return VisualStudioProjectMapper.makeName(dimensions);
    }

    private String projectPrefix(ProjectNativeBinary nativeBinary) {
        ProjectNativeComponentInternal component = (ProjectNativeComponentInternal)nativeBinary.getComponent();
        String projectPath = component.getProjectPath();
        if (":".equals(projectPath)) {
            return "";
        }
        return projectPath.substring(1).replace(":", "_") + "_";
    }

    private String componentName(ProjectNativeBinary nativeBinary) {
        return nativeBinary.getComponent().getName();
    }

    private String projectSuffix(ProjectNativeBinary nativeBinary) {
        return nativeBinary instanceof SharedLibraryBinary ? "Dll" : (nativeBinary instanceof NativeLibraryBinary ? "Lib" : (nativeBinary instanceof NativeExecutableBinary ? "Exe" : ""));
    }

    private static String makeName(Iterable<String> components) {
        StringBuilder builder = new StringBuilder();
        for (String component : components) {
            if (component == null || component.length() <= 0) continue;
            if (builder.length() == 0) {
                builder.append(component);
                continue;
            }
            builder.append(StringUtils.capitalize((String)component));
        }
        return builder.toString();
    }

    static class ProjectConfigurationNames {
        public final String project;
        public final String configuration;
        public final String platform;

        ProjectConfigurationNames(String project, String configuration, String platform) {
            this.project = project;
            this.configuration = configuration;
            this.platform = platform;
        }
    }
}

