/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.testing;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.tasks.testing.junit.report.DefaultTestReport;
import org.gradle.api.internal.tasks.testing.junit.result.AggregateTestResultsProvider;
import org.gradle.api.internal.tasks.testing.junit.result.BinaryResultBackedTestResultsProvider;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class TestReport
extends DefaultTask {
    private File destinationDir;
    private List<Object> results = new ArrayList<Object>();

    @OutputDirectory
    public File getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getTestResultDirs() {
        UnionFileCollection dirs = new UnionFileCollection(new FileCollection[0]);
        for (Object result : this.results) {
            this.addTo(result, dirs);
        }
        return dirs;
    }

    private void addTo(Object result, UnionFileCollection dirs) {
        if (result instanceof Test) {
            Test test = (Test)((Object)result);
            dirs.add((FileCollection)this.getProject().files(new Object[]{test.getBinResultsDir()}).builtBy(new Object[]{test}));
        } else if (result instanceof Iterable) {
            Iterable iterable = (Iterable)result;
            for (Object nested : iterable) {
                this.addTo(nested, dirs);
            }
        } else {
            dirs.add((FileCollection)this.getProject().files(new Object[]{result}));
        }
    }

    public void setTestResultDirs(Iterable<File> testResultDirs) {
        this.results.clear();
        this.reportOn(testResultDirs);
    }

    public void reportOn(Object ... results) {
        for (Object result : results) {
            this.results.add(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    void generateReport() {
        TestResultsProvider resultsProvider;
        block3: {
            resultsProvider = this.createAggregateProvider();
            try {
                if (resultsProvider.isHasResults()) {
                    DefaultTestReport testReport = new DefaultTestReport();
                    testReport.generateReport(resultsProvider, this.getDestinationDir());
                    break block3;
                }
                this.setDidWork(false);
            }
            catch (Throwable throwable) {
                CompositeStoppable.stoppable((Object[])new Object[]{resultsProvider}).stop();
                throw throwable;
            }
        }
        CompositeStoppable.stoppable((Object[])new Object[]{resultsProvider}).stop();
    }

    private TestResultsProvider createAggregateProvider() {
        LinkedList resultsProviders = new LinkedList();
        try {
            FileCollection resultDirs = this.getTestResultDirs();
            if (resultDirs.getFiles().size() == 1) {
                return new BinaryResultBackedTestResultsProvider(resultDirs.getSingleFile());
            }
            return new AggregateTestResultsProvider(CollectionUtils.collect((Iterable)resultDirs, resultsProviders, (Transformer)new Transformer<TestResultsProvider, File>(){

                public TestResultsProvider transform(File dir) {
                    return new BinaryResultBackedTestResultsProvider(dir);
                }
            }));
        }
        catch (RuntimeException e) {
            CompositeStoppable.stoppable(resultsProviders).stop();
            throw e;
        }
    }
}

