/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.javadoc;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.external.javadoc.MinimalJavadocOptions;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.external.javadoc.internal.JavadocExecHandleBuilder;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.process.internal.ExecException;
import org.gradle.util.GUtil;

public class Javadoc
extends SourceTask {
    private JavadocExecHandleBuilder javadocExecHandleBuilder = new JavadocExecHandleBuilder((ExecActionFactory)this.getServices().get(ExecActionFactory.class));
    private File destinationDir;
    private boolean failOnError = true;
    private String title;
    private String maxMemory;
    private MinimalJavadocOptions options = new StandardJavadocDocletOptions();
    private FileCollection classpath = this.getProject().files(new Object[0]);
    private String executable;

    @TaskAction
    protected void generate() {
        StandardJavadocDocletOptions docletOptions;
        File destinationDir = this.getDestinationDir();
        if (this.options.getDestinationDirectory() == null) {
            this.options.destinationDirectory(destinationDir);
        }
        this.options.classpath(new ArrayList<File>(this.getClasspath().getFiles()));
        if (!GUtil.isTrue((Object)this.options.getWindowTitle()) && GUtil.isTrue((Object)this.getTitle())) {
            this.options.windowTitle(this.getTitle());
        }
        if (this.options instanceof StandardJavadocDocletOptions && !GUtil.isTrue((Object)(docletOptions = (StandardJavadocDocletOptions)this.options).getDocTitle()) && GUtil.isTrue((Object)this.getTitle())) {
            docletOptions.setDocTitle(this.getTitle());
        }
        if (this.maxMemory != null) {
            List<String> jFlags = this.options.getJFlags();
            Iterator<String> jFlagsIt = jFlags.iterator();
            boolean containsXmx = false;
            while (!containsXmx && jFlagsIt.hasNext()) {
                String jFlag = jFlagsIt.next();
                if (!jFlag.startsWith("-Xmx")) continue;
                containsXmx = true;
            }
            if (!containsXmx) {
                this.options.jFlags("-Xmx" + this.maxMemory);
            }
        }
        ArrayList<String> sourceNames = new ArrayList<String>();
        for (File sourceFile : this.getSource()) {
            sourceNames.add(sourceFile.getAbsolutePath());
        }
        this.options.setSourceNames(sourceNames);
        this.executeExternalJavadoc();
    }

    private void executeExternalJavadoc() {
        this.javadocExecHandleBuilder.setExecutable(this.executable);
        this.javadocExecHandleBuilder.execDirectory(this.getProject().getRootDir()).options(this.options).optionsFile(this.getOptionsFile());
        ExecAction execAction = this.javadocExecHandleBuilder.getExecHandle();
        if (!this.failOnError) {
            execAction.setIgnoreExitValue(true);
        }
        try {
            execAction.execute();
        }
        catch (ExecException e) {
            throw new GradleException("Javadoc generation failed.", (Throwable)e);
        }
    }

    void setJavadocExecHandleBuilder(JavadocExecHandleBuilder javadocExecHandleBuilder) {
        if (javadocExecHandleBuilder == null) {
            throw new IllegalArgumentException("javadocExecHandleBuilder == null!");
        }
        this.javadocExecHandleBuilder = javadocExecHandleBuilder;
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    public String getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(String maxMemory) {
        this.maxMemory = maxMemory;
    }

    @Input
    @Optional
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isVerbose() {
        return this.options.isVerbose();
    }

    public void setVerbose(boolean verbose) {
        if (verbose) {
            this.options.verbose();
        }
    }

    @InputFiles
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Nested
    public MinimalJavadocOptions getOptions() {
        return this.options;
    }

    public void setOptions(MinimalJavadocOptions options) {
        this.options = options;
    }

    public void options(Closure block) {
        this.getProject().configure((Object)this.getOptions(), block);
    }

    @Input
    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public File getOptionsFile() {
        return new File(this.getTemporaryDir(), "javadoc.options");
    }

    @Input
    @Optional
    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }
}

