/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import java.io.File;
import org.gradle.api.AntBuilder;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompilerFactory;
import org.gradle.api.internal.tasks.compile.DelegatingJavaCompiler;
import org.gradle.api.internal.tasks.compile.InProcessJavaCompilerFactory;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonManager;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalJavaCompilerFactory;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.internal.Factory;
import org.gradle.util.SingleMessageLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCompile
extends AbstractCompile {
    private File dependencyCacheDir;
    private final CompileOptions compileOptions = new CompileOptions();

    @TaskAction
    protected void compile(IncrementalTaskInputs inputs) {
        if (!this.compileOptions.isIncremental()) {
            this.compile();
            return;
        }
        SingleMessageLogger.incubatingFeatureUsed((String)"Incremental java compilation");
        IncrementalJavaCompilerFactory factory = new IncrementalJavaCompilerFactory(this.getProject(), this.getPath(), this.createCompiler(), this.source);
        Compiler<JavaCompileSpec> compiler = factory.createCompiler(inputs);
        this.performCompilation(compiler);
    }

    @Override
    protected void compile() {
        this.performCompilation(this.createCompiler());
    }

    private CleaningJavaCompiler createCompiler() {
        Factory antBuilderFactory = this.getServices().getFactory(AntBuilder.class);
        InProcessJavaCompilerFactory inProcessCompilerFactory = new InProcessJavaCompilerFactory();
        ProjectInternal projectInternal = (ProjectInternal)this.getProject();
        CompilerDaemonManager compilerDaemonManager = (CompilerDaemonManager)this.getServices().get(CompilerDaemonManager.class);
        DefaultJavaCompilerFactory defaultCompilerFactory = new DefaultJavaCompilerFactory(projectInternal, inProcessCompilerFactory, compilerDaemonManager);
        DelegatingJavaCompiler javaCompiler = new DelegatingJavaCompiler(defaultCompilerFactory);
        return new CleaningJavaCompiler(javaCompiler, (Factory<AntBuilder>)antBuilderFactory, this.getOutputs());
    }

    private void performCompilation(Compiler<JavaCompileSpec> compiler) {
        DefaultJavaCompileSpec spec = new DefaultJavaCompileSpec();
        spec.setSource((FileCollection)this.getSource());
        spec.setDestinationDir(this.getDestinationDir());
        spec.setClasspath((Iterable<File>)this.getClasspath());
        spec.setDependencyCacheDir(this.getDependencyCacheDir());
        spec.setSourceCompatibility(this.getSourceCompatibility());
        spec.setTargetCompatibility(this.getTargetCompatibility());
        spec.setCompileOptions(this.compileOptions);
        WorkResult result = compiler.execute(spec);
        this.setDidWork(result.getDidWork());
    }

    @OutputDirectory
    public File getDependencyCacheDir() {
        return this.dependencyCacheDir;
    }

    public void setDependencyCacheDir(File dependencyCacheDir) {
        this.dependencyCacheDir = dependencyCacheDir;
    }

    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }
}

