/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.file.DefaultSourceDirectorySet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.jvm.DefaultClassDirectoryBinary;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.jvm.ClassDirectoryBinary;
import org.gradle.api.tasks.Copy;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.plugins.LanguageBasePlugin;
import org.gradle.language.jvm.ResourceSet;
import org.gradle.language.jvm.internal.DefaultResourceSet;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.runtime.base.BinaryContainer;
import org.gradle.runtime.base.internal.BinaryInternal;
import org.gradle.runtime.base.internal.BinaryNamingScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class JvmLanguagePlugin
implements Plugin<Project> {
    private final Instantiator instantiator;
    private final FileResolver fileResolver;

    @Inject
    public JvmLanguagePlugin(Instantiator instantiator, FileResolver fileResolver) {
        this.instantiator = instantiator;
        this.fileResolver = fileResolver;
    }

    public void apply(final Project target) {
        target.getPlugins().apply(LanguageBasePlugin.class);
        ProjectSourceSet projectSourceSet = (ProjectSourceSet)target.getExtensions().getByType(ProjectSourceSet.class);
        projectSourceSet.all((Action)new Action<FunctionalSourceSet>(){

            public void execute(final FunctionalSourceSet functionalSourceSet) {
                functionalSourceSet.registerFactory(ResourceSet.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<ResourceSet>(){

                    public ResourceSet create(String name) {
                        return (ResourceSet)JvmLanguagePlugin.this.instantiator.newInstance(DefaultResourceSet.class, new Object[]{name, JvmLanguagePlugin.this.instantiator.newInstance(DefaultSourceDirectorySet.class, new Object[]{name, JvmLanguagePlugin.this.fileResolver}), functionalSourceSet});
                    }
                });
            }
        });
        BinaryContainer binaryContainer = (BinaryContainer)target.getExtensions().getByType(BinaryContainer.class);
        binaryContainer.registerFactory(ClassDirectoryBinary.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<ClassDirectoryBinary>(){

            public ClassDirectoryBinary create(String name) {
                return (ClassDirectoryBinary)JvmLanguagePlugin.this.instantiator.newInstance(DefaultClassDirectoryBinary.class, new Object[]{name});
            }
        });
        binaryContainer.withType(ClassDirectoryBinary.class).all((Action)new Action<ClassDirectoryBinary>(){

            public void execute(final ClassDirectoryBinary binary) {
                final BinaryNamingScheme namingScheme = ((BinaryInternal)binary).getNamingScheme();
                ConventionMapping conventionMapping = new DslObject((Object)binary).getConventionMapping();
                conventionMapping.map("classesDir", (Callable)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return new File(new File(target.getBuildDir(), "classes"), namingScheme.getOutputDirectoryBase());
                    }
                });
                binary.getSource().withType(ResourceSet.class).all((Action)new Action<ResourceSet>(){

                    public void execute(ResourceSet resourceSet) {
                        Copy resourcesTask = (Copy)target.getTasks().create(namingScheme.getTaskName("process", "resources"), ProcessResources.class);
                        resourcesTask.setDescription(String.format("Processes %s.", resourceSet));
                        new DslObject((Object)resourcesTask).getConventionMapping().map("destinationDir", (Callable)new Callable<File>(){

                            @Override
                            public File call() throws Exception {
                                return binary.getResourcesDir();
                            }
                        });
                        binary.builtBy(new Object[]{resourcesTask});
                        resourcesTask.from(new Object[]{resourceSet.getSource()});
                    }
                });
            }
        });
    }
}

