/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.file.DefaultSourceDirectorySet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.jvm.ClassDirectoryBinary;
import org.gradle.api.plugins.JvmLanguagePlugin;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.DefaultProjectSourceSet;
import org.gradle.language.java.JavaSourceSet;
import org.gradle.language.java.internal.DefaultJavaSourceSet;
import org.gradle.runtime.base.BinaryContainer;
import org.gradle.runtime.base.internal.BinaryInternal;
import org.gradle.runtime.base.internal.BinaryNamingScheme;
import org.gradle.runtime.jvm.internal.DefaultClasspath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class JavaLanguagePlugin
implements Plugin<Project> {
    private final Instantiator instantiator;
    private final FileResolver fileResolver;

    @Inject
    public JavaLanguagePlugin(Instantiator instantiator, FileResolver fileResolver) {
        this.instantiator = instantiator;
        this.fileResolver = fileResolver;
    }

    public void apply(final Project target) {
        target.getPlugins().apply(JvmLanguagePlugin.class);
        BinaryContainer jvmBinaryContainer = (BinaryContainer)target.getExtensions().getByType(BinaryContainer.class);
        jvmBinaryContainer.withType(ClassDirectoryBinary.class).all((Action)new Action<ClassDirectoryBinary>(){

            public void execute(final ClassDirectoryBinary binary) {
                final BinaryNamingScheme namingScheme = ((BinaryInternal)binary).getNamingScheme();
                binary.getSource().withType(JavaSourceSet.class).all((Action)new Action<JavaSourceSet>(){

                    public void execute(JavaSourceSet javaSourceSet) {
                        JavaCompile compileTask = (JavaCompile)target.getTasks().create(namingScheme.getTaskName("compile", "java"), JavaCompile.class);
                        JavaLanguagePlugin.this.configureCompileTask(compileTask, javaSourceSet, binary);
                        binary.builtBy(new Object[]{compileTask});
                    }
                });
            }
        });
        ProjectSourceSet projectSourceSet = (ProjectSourceSet)target.getExtensions().getByType(DefaultProjectSourceSet.class);
        projectSourceSet.all((Action)new Action<FunctionalSourceSet>(){

            public void execute(final FunctionalSourceSet functionalSourceSet) {
                functionalSourceSet.registerFactory(JavaSourceSet.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<JavaSourceSet>(){

                    public JavaSourceSet create(String name) {
                        return (JavaSourceSet)JavaLanguagePlugin.this.instantiator.newInstance(DefaultJavaSourceSet.class, new Object[]{name, JavaLanguagePlugin.this.instantiator.newInstance(DefaultSourceDirectorySet.class, new Object[]{name, JavaLanguagePlugin.this.fileResolver}), JavaLanguagePlugin.this.instantiator.newInstance(DefaultClasspath.class, new Object[]{JavaLanguagePlugin.this.fileResolver, target.getTasks()}), functionalSourceSet});
                    }
                });
            }
        });
    }

    public void configureCompileTask(AbstractCompile compile, final JavaSourceSet sourceSet, final ClassDirectoryBinary binary) {
        compile.setDescription(String.format("Compiles %s.", sourceSet));
        compile.setSource(sourceSet.getSource());
        compile.dependsOn(new Object[]{sourceSet});
        ConventionMapping conventionMapping = compile.getConventionMapping();
        conventionMapping.map("classpath", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return sourceSet.getCompileClasspath().getFiles();
            }
        });
        conventionMapping.map("destinationDir", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return binary.getClassesDir();
            }
        });
    }
}

