/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.java.archives.internal;

import groovy.lang.Closure;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.taskdefs.Manifest;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.ManifestException;
import org.gradle.api.java.archives.ManifestMergeSpec;
import org.gradle.api.java.archives.internal.DefaultAttributes;
import org.gradle.api.java.archives.internal.DefaultManifestMergeSpec;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.IoActions;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultManifest
implements Manifest {
    private List<ManifestMergeSpec> manifestMergeSpecs = new ArrayList<ManifestMergeSpec>();
    private DefaultAttributes attributes = new DefaultAttributes();
    private Map<String, Attributes> sections = new LinkedHashMap<String, Attributes>();
    private FileResolver fileResolver;

    public DefaultManifest(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
        this.init();
    }

    public DefaultManifest(Object manifestPath, FileResolver fileResolver) {
        this.fileResolver = fileResolver;
        this.read(manifestPath);
    }

    private void init() {
        this.getAttributes().put("Manifest-Version", "1.0");
    }

    public DefaultManifest mainAttributes(Map<String, ?> attributes) {
        return this.attributes((Map)attributes);
    }

    @Override
    public DefaultManifest attributes(Map<String, ?> attributes) {
        this.getAttributes().putAll(attributes);
        return this;
    }

    @Override
    public DefaultManifest attributes(Map<String, ?> attributes, String sectionName) {
        if (!this.sections.containsKey(sectionName)) {
            this.sections.put(sectionName, new DefaultAttributes());
        }
        this.sections.get(sectionName).putAll(attributes);
        return this;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public Map<String, Attributes> getSections() {
        return this.sections;
    }

    public DefaultManifest clear() {
        this.attributes.clear();
        this.sections.clear();
        this.manifestMergeSpecs.clear();
        this.init();
        return this;
    }

    private org.apache.tools.ant.taskdefs.Manifest generateAntManifest() {
        org.apache.tools.ant.taskdefs.Manifest antManifest = new org.apache.tools.ant.taskdefs.Manifest();
        this.addAttributesToAnt(antManifest);
        this.addSectionAttributesToAnt(antManifest);
        return antManifest;
    }

    private void addAttributesToAnt(org.apache.tools.ant.taskdefs.Manifest antManifest) {
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            try {
                antManifest.addConfiguredAttribute(new Manifest.Attribute(entry.getKey().toString(), entry.getValue().toString()));
            }
            catch (org.apache.tools.ant.taskdefs.ManifestException e) {
                throw new ManifestException(e.getMessage(), e);
            }
        }
    }

    private void addSectionAttributesToAnt(org.apache.tools.ant.taskdefs.Manifest antManifest) {
        for (Map.Entry<String, Attributes> entry : this.sections.entrySet()) {
            Manifest.Section section = new Manifest.Section();
            section.setName(entry.getKey());
            try {
                antManifest.addConfiguredSection(section);
                for (Map.Entry attributeEntry : entry.getValue().entrySet()) {
                    section.addConfiguredAttribute(new Manifest.Attribute(((String)attributeEntry.getKey()).toString(), attributeEntry.getValue().toString()));
                }
            }
            catch (org.apache.tools.ant.taskdefs.ManifestException e) {
                throw new ManifestException(e.getMessage(), e);
            }
        }
    }

    @Override
    public DefaultManifest from(Object ... mergePaths) {
        this.from((Object)mergePaths, null);
        return this;
    }

    @Override
    public DefaultManifest from(Object mergePaths, Closure closure) {
        DefaultManifestMergeSpec mergeSpec = new DefaultManifestMergeSpec();
        mergeSpec.from(mergePaths);
        this.manifestMergeSpecs.add(mergeSpec);
        ConfigureUtil.configure((Closure)closure, (Object)mergeSpec);
        return this;
    }

    @Override
    public DefaultManifest getEffectiveManifest() {
        return this.getEffectiveManifestInternal(this);
    }

    protected DefaultManifest getEffectiveManifestInternal(DefaultManifest baseManifest) {
        DefaultManifest resultManifest = baseManifest;
        for (ManifestMergeSpec manifestMergeSpec : this.manifestMergeSpecs) {
            resultManifest = ((DefaultManifestMergeSpec)manifestMergeSpec).merge(resultManifest, this.fileResolver);
        }
        return resultManifest;
    }

    @Override
    public DefaultManifest writeTo(Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer);
        try {
            this.getEffectiveManifest().generateAntManifest().write(printWriter);
            printWriter.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        return this;
    }

    @Override
    public Manifest writeTo(Object path) {
        IoActions.writeTextFile((File)this.fileResolver.resolve(path), (Action)new ErroringAction<Writer>(){

            protected void doExecute(Writer writer) throws Exception {
                DefaultManifest.this.writeTo(writer);
            }
        });
        return this;
    }

    public List<ManifestMergeSpec> getMergeSpecs() {
        return this.manifestMergeSpecs;
    }

    public boolean isEqualsTo(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof DefaultManifest)) {
            return false;
        }
        DefaultManifest effectiveThis = this.getEffectiveManifest();
        DefaultManifest effectiveThat = ((DefaultManifest)o).getEffectiveManifest();
        if (!effectiveThis.attributes.equals(effectiveThat.attributes)) {
            return false;
        }
        return effectiveThis.sections.equals(effectiveThat.sections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(Object manifestPath) {
        File manifestFile = this.fileResolver.resolve(manifestPath);
        try {
            org.apache.tools.ant.taskdefs.Manifest antManifest;
            FileReader reader = new FileReader(manifestFile);
            try {
                antManifest = new org.apache.tools.ant.taskdefs.Manifest((Reader)reader);
            }
            finally {
                reader.close();
            }
            this.addAntManifestToAttributes(antManifest);
            this.addAntManifestToSections(antManifest);
        }
        catch (org.apache.tools.ant.taskdefs.ManifestException e) {
            throw new ManifestException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private void addAntManifestToAttributes(org.apache.tools.ant.taskdefs.Manifest antManifest) {
        Enumeration attributeKeys = antManifest.getMainSection().getAttributeKeys();
        while (attributeKeys.hasMoreElements()) {
            String key = (String)attributeKeys.nextElement();
            String attributeKey = antManifest.getMainSection().getAttribute(key).getName();
            this.attributes.put(attributeKey, (Object)antManifest.getMainSection().getAttributeValue(key));
        }
        this.attributes.put("Manifest-Version", (Object)antManifest.getManifestVersion());
    }

    private void addAntManifestToSections(org.apache.tools.ant.taskdefs.Manifest antManifest) {
        Enumeration sectionNames = antManifest.getSectionNames();
        while (sectionNames.hasMoreElements()) {
            String sectionName = (String)sectionNames.nextElement();
            this.addAntManifestToSection(antManifest, sectionName);
        }
    }

    private void addAntManifestToSection(org.apache.tools.ant.taskdefs.Manifest antManifest, String sectionName) {
        DefaultAttributes attributes = new DefaultAttributes();
        this.sections.put(sectionName, attributes);
        Enumeration attributeKeys = antManifest.getSection(sectionName).getAttributeKeys();
        while (attributeKeys.hasMoreElements()) {
            String key = (String)attributeKeys.nextElement();
            String attributeKey = antManifest.getSection(sectionName).getAttribute(key).getName();
            attributes.put(attributeKey, (Object)antManifest.getSection(sectionName).getAttributeValue(key));
        }
    }
}

