/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.ClassFileExtractionManager;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junit.JULRedirector;
import org.gradle.api.internal.tasks.testing.testng.TestNGDetector;
import org.gradle.api.internal.tasks.testing.testng.TestNGSpec;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestClassProcessor;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.testng.TestNGOptions;
import org.gradle.internal.Factory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.logging.StandardOutputRedirector;
import org.gradle.process.internal.WorkerProcessBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGTestFramework
implements TestFramework {
    private TestNGOptions options;
    private TestNGDetector detector;
    final Test testTask;
    private DefaultTestFilter filter;

    public TestNGTestFramework(Test testTask, DefaultTestFilter filter, Instantiator instantiator) {
        this.testTask = testTask;
        this.filter = filter;
        this.options = (TestNGOptions)instantiator.newInstance(TestNGOptions.class, new Object[]{testTask.getProject().getProjectDir()});
        this.options.setAnnotationsOnSourceCompatibility(JavaVersion.toVersion((Object)testTask.getProject().property("sourceCompatibility")));
        TestNGTestFramework.conventionMapOutputDirectory(this.options, testTask.getReports().getHtml());
        this.detector = new TestNGDetector(new ClassFileExtractionManager((Factory<File>)testTask.getTemporaryDirFactory()));
    }

    private static void conventionMapOutputDirectory(TestNGOptions options, final DirectoryReport html) {
        new DslObject((Object)options).getConventionMapping().map("outputDirectory", (Callable)new Callable<File>(){

            @Override
            public File call() {
                return html.getDestination();
            }
        });
    }

    @Override
    public WorkerTestClassProcessorFactory getProcessorFactory() {
        this.options.setTestResources(this.testTask.getTestSrcDirs());
        List<File> suiteFiles = this.options.getSuites(this.testTask.getTemporaryDir());
        return new TestClassProcessorFactoryImpl(this.options.getOutputDirectory(), new TestNGSpec(this.options, this.filter), suiteFiles);
    }

    @Override
    public Action<WorkerProcessBuilder> getWorkerConfigurationAction() {
        return new Action<WorkerProcessBuilder>(){

            public void execute(WorkerProcessBuilder workerProcessBuilder) {
                workerProcessBuilder.sharedPackages(new String[]{"org.testng"});
            }
        };
    }

    @Override
    public TestNGOptions getOptions() {
        return this.options;
    }

    void setOptions(TestNGOptions options) {
        this.options = options;
    }

    @Override
    public TestNGDetector getDetector() {
        return this.detector;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestClassProcessorFactoryImpl
    implements WorkerTestClassProcessorFactory,
    Serializable {
        private final File testReportDir;
        private final TestNGSpec options;
        private final List<File> suiteFiles;

        public TestClassProcessorFactoryImpl(File testReportDir, TestNGSpec options, List<File> suiteFiles) {
            this.testReportDir = testReportDir;
            this.options = options;
            this.suiteFiles = suiteFiles;
        }

        @Override
        public TestClassProcessor create(ServiceRegistry serviceRegistry) {
            return new TestNGTestClassProcessor(this.testReportDir, this.options, this.suiteFiles, (IdGenerator)serviceRegistry.get(IdGenerator.class), (StandardOutputRedirector)new JULRedirector());
        }
    }
}

