/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.tools.ant.util.DateUtils;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestFailure;
import org.gradle.api.internal.tasks.testing.junit.result.TestMethodResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestOutputAssociation;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.internal.xml.SimpleXmlWriter;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitXmlResultWriter {
    private final String hostName;
    private final TestResultsProvider testResultsProvider;
    private final TestOutputAssociation outputAssociation;

    public JUnitXmlResultWriter(String hostName, TestResultsProvider testResultsProvider, TestOutputAssociation outputAssociation) {
        this.hostName = hostName;
        this.testResultsProvider = testResultsProvider;
        this.outputAssociation = outputAssociation;
    }

    public void write(TestClassResult result, OutputStream output) {
        String className = result.getClassName();
        long classId = result.getId();
        try {
            SimpleXmlWriter writer = new SimpleXmlWriter(output, "  ");
            writer.startElement("testsuite").attribute("name", className).attribute("tests", String.valueOf(result.getTestsCount())).attribute("skipped", String.valueOf(result.getSkippedCount())).attribute("failures", String.valueOf(result.getFailuresCount())).attribute("errors", "0").attribute("timestamp", DateUtils.format((long)result.getStartTime(), (String)"yyyy-MM-dd'T'HH:mm:ss")).attribute("hostname", this.hostName).attribute("time", String.valueOf((double)result.getDuration() / 1000.0));
            writer.startElement("properties");
            writer.endElement();
            this.writeTests(writer, result.getResults(), className, classId);
            writer.startElement("system-out");
            this.writeOutputs(writer, classId, this.outputAssociation.equals((Object)TestOutputAssociation.WITH_SUITE), TestOutputEvent.Destination.StdOut);
            writer.endElement();
            writer.startElement("system-err");
            this.writeOutputs(writer, classId, this.outputAssociation.equals((Object)TestOutputAssociation.WITH_SUITE), TestOutputEvent.Destination.StdErr);
            writer.endElement();
            writer.endElement();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private void writeOutputs(SimpleXmlWriter writer, long classId, boolean allClassOutput, TestOutputEvent.Destination destination) throws IOException {
        writer.startCDATA();
        if (allClassOutput) {
            this.testResultsProvider.writeAllOutput(classId, destination, (Writer)writer);
        } else {
            this.testResultsProvider.writeNonTestOutput(classId, destination, (Writer)writer);
        }
        writer.endCDATA();
    }

    private void writeOutputs(SimpleXmlWriter writer, long classId, long testId, TestOutputEvent.Destination destination) throws IOException {
        writer.startCDATA();
        this.testResultsProvider.writeTestOutput(classId, testId, destination, (Writer)writer);
        writer.endCDATA();
    }

    private void writeTests(SimpleXmlWriter writer, Iterable<TestMethodResult> methodResults, String className, long classId) throws IOException {
        for (TestMethodResult methodResult : methodResults) {
            writer.startElement("testcase").attribute("name", methodResult.getName()).attribute("classname", className).attribute("time", String.valueOf((double)methodResult.getDuration() / 1000.0));
            if (methodResult.getResultType() == TestResult.ResultType.SKIPPED) {
                writer.startElement("skipped");
                writer.endElement();
            } else {
                for (TestFailure failure : methodResult.getFailures()) {
                    writer.startElement("failure").attribute("message", failure.getMessage()).attribute("type", failure.getExceptionType());
                    writer.characters((CharSequence)failure.getStackTrace());
                    writer.endElement();
                }
            }
            if (this.outputAssociation.equals((Object)TestOutputAssociation.WITH_TESTCASE)) {
                writer.startElement("system-out");
                this.writeOutputs(writer, classId, methodResult.getId(), TestOutputEvent.Destination.StdOut);
                writer.endElement();
                writer.startElement("system-err");
                this.writeOutputs(writer, classId, methodResult.getId(), TestOutputEvent.Destination.StdErr);
                writer.endElement();
            }
            writer.endElement();
        }
    }
}

