/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.report;

import java.io.File;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.testing.junit.report.AllTestResults;
import org.gradle.api.internal.tasks.testing.junit.report.ClassPageRenderer;
import org.gradle.api.internal.tasks.testing.junit.report.ClassTestResults;
import org.gradle.api.internal.tasks.testing.junit.report.CompositeTestResults;
import org.gradle.api.internal.tasks.testing.junit.report.OverviewPageRenderer;
import org.gradle.api.internal.tasks.testing.junit.report.PackagePageRenderer;
import org.gradle.api.internal.tasks.testing.junit.report.PackageTestResults;
import org.gradle.api.internal.tasks.testing.junit.report.PageRenderer;
import org.gradle.api.internal.tasks.testing.junit.report.TestReporter;
import org.gradle.api.internal.tasks.testing.junit.report.TestResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestFailure;
import org.gradle.api.internal.tasks.testing.junit.result.TestMethodResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.reporting.HtmlReportRenderer;
import org.gradle.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTestReport
implements TestReporter {
    private final HtmlReportRenderer htmlRenderer = new HtmlReportRenderer();
    private static final Logger LOG = Logging.getLogger(DefaultTestReport.class);

    public DefaultTestReport() {
        this.htmlRenderer.requireResource(this.getClass().getResource("/org/gradle/reporting/report.js"));
        this.htmlRenderer.requireResource(this.getClass().getResource("/org/gradle/reporting/base-style.css"));
        this.htmlRenderer.requireResource(this.getClass().getResource("/org/gradle/reporting/css3-pie-1.0beta3.htc"));
        this.htmlRenderer.requireResource(this.getClass().getResource("style.css"));
    }

    @Override
    public void generateReport(TestResultsProvider resultsProvider, File reportDir) {
        LOG.info("Generating HTML test report...");
        Clock clock = new Clock();
        AllTestResults model = this.loadModelFromProvider(resultsProvider);
        this.generateFiles(model, resultsProvider, reportDir);
        LOG.info("Finished generating test html results ({}) into: {}", (Object)clock.getTime(), (Object)reportDir);
    }

    private AllTestResults loadModelFromProvider(TestResultsProvider resultsProvider) {
        final AllTestResults model = new AllTestResults();
        resultsProvider.visitClasses((Action<? super TestClassResult>)new Action<TestClassResult>(){

            public void execute(TestClassResult classResult) {
                model.addTestClass(classResult.getId(), classResult.getClassName());
                List<TestMethodResult> collectedResults = classResult.getResults();
                for (TestMethodResult collectedResult : collectedResults) {
                    TestResult testResult = model.addTest(classResult.getId(), classResult.getClassName(), collectedResult.getName(), collectedResult.getDuration());
                    if (collectedResult.getResultType() == TestResult.ResultType.SKIPPED) {
                        testResult.setIgnored();
                        continue;
                    }
                    List<TestFailure> failures = collectedResult.getFailures();
                    for (TestFailure failure : failures) {
                        testResult.addFailure(failure);
                    }
                }
            }
        });
        return model;
    }

    private void generateFiles(AllTestResults model, TestResultsProvider resultsProvider, File reportDir) {
        try {
            this.generatePage(model, new OverviewPageRenderer(), new File(reportDir, "index.html"));
            for (PackageTestResults packageResults : model.getPackages()) {
                this.generatePage(packageResults, new PackagePageRenderer(), new File(reportDir, packageResults.getBaseUrl()));
                for (ClassTestResults classResults : packageResults.getClasses()) {
                    this.generatePage(classResults, new ClassPageRenderer(classResults.getId(), resultsProvider), new File(reportDir, classResults.getBaseUrl()));
                }
            }
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not generate test report to '%s'.", reportDir), (Throwable)e);
        }
    }

    private <T extends CompositeTestResults> void generatePage(T model, PageRenderer<T> renderer, File outputFile) throws Exception {
        this.htmlRenderer.renderer(renderer).writeTo(model, outputFile);
    }
}

