/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Transformer;
import org.gradle.api.internal.tasks.testing.filter.TestSelectionMatcher;
import org.gradle.api.internal.tasks.testing.junit.CategoryFilter;
import org.gradle.api.internal.tasks.testing.junit.JUnitSpec;
import org.gradle.api.internal.tasks.testing.junit.TestClassExecutionListener;
import org.gradle.internal.concurrent.ThreadSafe;
import org.gradle.util.CollectionUtils;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

public class JUnitTestClassExecuter {
    private final ClassLoader applicationClassLoader;
    private final RunListener listener;
    private final JUnitSpec options;
    private final TestClassExecutionListener executionListener;

    public JUnitTestClassExecuter(ClassLoader applicationClassLoader, JUnitSpec spec, RunListener listener, TestClassExecutionListener executionListener) {
        assert (executionListener instanceof ThreadSafe);
        this.applicationClassLoader = applicationClassLoader;
        this.listener = listener;
        this.options = spec;
        this.executionListener = executionListener;
    }

    public void execute(String testClassName) {
        this.executionListener.testClassStarted(testClassName);
        Throwable failure = null;
        try {
            this.runTestClass(testClassName);
        }
        catch (Throwable throwable) {
            failure = throwable;
        }
        this.executionListener.testClassFinished(failure);
    }

    private void runTestClass(String testClassName) throws ClassNotFoundException {
        Class<?> testClass = Class.forName(testClassName, true, this.applicationClassLoader);
        Request request = Request.aClass(testClass);
        if (this.options.hasCategoryConfiguration()) {
            Transformer transformer = new Transformer<Class<?>, String>(){

                public Class<?> transform(String original) {
                    try {
                        return JUnitTestClassExecuter.this.applicationClassLoader.loadClass(original);
                    }
                    catch (ClassNotFoundException e) {
                        throw new InvalidUserDataException(String.format("Can't load category class [%s].", original), (Throwable)e);
                    }
                }
            };
            request = request.filterWith((Filter)new CategoryFilter(CollectionUtils.collect(this.options.getIncludeCategories(), (Transformer)transformer), CollectionUtils.collect(this.options.getExcludeCategories(), (Transformer)transformer)));
        }
        if (!this.options.getIncludedTests().isEmpty()) {
            request = request.filterWith((Filter)new MethodNameFilter(this.options.getIncludedTests()));
        }
        Runner runner = request.getRunner();
        if (!Filter.class.getName().equals(runner.getDescription().getDisplayName())) {
            RunNotifier notifier = new RunNotifier();
            notifier.addListener(this.listener);
            runner.run(notifier);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodNameFilter
    extends Filter {
        private final TestSelectionMatcher matcher;

        public MethodNameFilter(Iterable<String> includedTests) {
            this.matcher = new TestSelectionMatcher(includedTests);
        }

        public boolean shouldRun(Description description) {
            return this.matcher.matchesTest(description.getClassName(), description.getMethodName());
        }

        public String describe() {
            return "Includes matching test methods";
        }
    }
}

