/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import org.gradle.api.Action;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.incremental.SourceToNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependencyInfo;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependencyInfoProvider;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotter;
import org.gradle.api.internal.tasks.compile.incremental.jar.LocalJarSnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.model.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.DefaultRecompilationSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.JarChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.JavaChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;

public class RecompilationSpecProvider {
    private final SourceToNameConverter sourceToNameConverter;
    private final ClassDependencyInfoProvider dependencyInfoProvider;
    private final FileOperations fileOperations;
    private final JarSnapshotter jarSnapshotter;
    private LocalJarSnapshotCache jarSnapshotCache;

    public RecompilationSpecProvider(SourceToNameConverter sourceToNameConverter, ClassDependencyInfoProvider dependencyInfoProvider, FileOperations fileOperations, JarSnapshotter jarSnapshotter, LocalJarSnapshotCache jarSnapshotCache) {
        this.sourceToNameConverter = sourceToNameConverter;
        this.dependencyInfoProvider = dependencyInfoProvider;
        this.fileOperations = fileOperations;
        this.jarSnapshotter = jarSnapshotter;
        this.jarSnapshotCache = jarSnapshotCache;
    }

    public RecompilationSpec provideRecompilationSpec(IncrementalTaskInputs inputs) {
        ClassDependencyInfo dependencyInfo = this.dependencyInfoProvider.provideInfo();
        PreviousCompilation previousCompilation = new PreviousCompilation(dependencyInfo, this.jarSnapshotCache);
        DefaultRecompilationSpec spec = new DefaultRecompilationSpec(dependencyInfo);
        JavaChangeProcessor javaChangeProcessor = new JavaChangeProcessor(dependencyInfo, this.sourceToNameConverter);
        JarChangeProcessor jarChangeProcessor = new JarChangeProcessor(this.fileOperations, this.jarSnapshotter, previousCompilation);
        InputChangeAction action = new InputChangeAction(spec, javaChangeProcessor, jarChangeProcessor);
        inputs.outOfDate((Action)action);
        if (((InputChangeAction)action).spec.fullRebuildCause != null) {
            return action.spec;
        }
        inputs.removed((Action)action);
        return action.spec;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InputChangeAction
    implements Action<InputFileDetails> {
        private final DefaultRecompilationSpec spec;
        private final JavaChangeProcessor javaChangeProcessor;
        private final JarChangeProcessor jarChangeProcessor;

        public InputChangeAction(DefaultRecompilationSpec spec, JavaChangeProcessor javaChangeProcessor, JarChangeProcessor jarChangeProcessor) {
            this.spec = spec;
            this.javaChangeProcessor = javaChangeProcessor;
            this.jarChangeProcessor = jarChangeProcessor;
        }

        public void execute(InputFileDetails input) {
            if (this.spec.fullRebuildCause != null) {
                return;
            }
            if (input.getFile().getName().endsWith(".java")) {
                this.javaChangeProcessor.processChange(input, this.spec);
            }
            if (input.getFile().getName().endsWith(".jar")) {
                this.jarChangeProcessor.processChange(input, this.spec);
            }
        }
    }
}

