/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import org.gradle.api.internal.tasks.compile.incremental.SourceToNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependencyInfo;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.recomp.DefaultRecompilationSpec;
import org.gradle.api.tasks.incremental.InputFileDetails;

class JavaChangeProcessor {
    private final ClassDependencyInfo dependencyInfo;
    private final SourceToNameConverter sourceToNameConverter;

    public JavaChangeProcessor(ClassDependencyInfo dependencyInfo, SourceToNameConverter sourceToNameConverter) {
        this.dependencyInfo = dependencyInfo;
        this.sourceToNameConverter = sourceToNameConverter;
    }

    public void processChange(InputFileDetails input, DefaultRecompilationSpec spec) {
        String className = this.sourceToNameConverter.getClassName(input.getFile());
        spec.classesToCompile.add(className);
        DependentsSet actualDependents = this.dependencyInfo.getRelevantDependents(className);
        if (actualDependents.isDependencyToAll()) {
            spec.fullRebuildCause = input.getFile();
            return;
        }
        spec.classesToCompile.addAll(actualDependents.getDependentClasses());
    }
}

