/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarArchive;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarChangeDependentsFinder;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotter;
import org.gradle.api.internal.tasks.compile.incremental.model.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.DefaultRecompilationSpec;
import org.gradle.api.tasks.incremental.InputFileDetails;

class JarChangeProcessor {
    private final FileOperations fileOperations;
    private final JarSnapshotter jarSnapshotter;
    private final PreviousCompilation previousCompilation;

    public JarChangeProcessor(FileOperations fileOperations, JarSnapshotter jarSnapshotter, PreviousCompilation previousCompilation) {
        this.fileOperations = fileOperations;
        this.jarSnapshotter = jarSnapshotter;
        this.previousCompilation = previousCompilation;
    }

    public void processChange(InputFileDetails input, DefaultRecompilationSpec spec) {
        JarChangeDependentsFinder dependentsFinder = new JarChangeDependentsFinder(this.jarSnapshotter, this.previousCompilation);
        JarArchive jarArchive = new JarArchive(input.getFile(), this.fileOperations.zipTree((Object)input.getFile()));
        DependentsSet actualDependents = dependentsFinder.getActualDependents(input, jarArchive);
        if (actualDependents.isDependencyToAll()) {
            spec.fullRebuildCause = input.getFile();
            return;
        }
        spec.classesToCompile.addAll(actualDependents.getDependentClasses());
    }
}

