/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.tasks.compile.incremental.DummySerializer;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalJarSnapshotCache {
    private File storage;
    private Map<File, JarSnapshot> snapshots;

    public LocalJarSnapshotCache(File storage) {
        this.storage = storage;
    }

    public JarSnapshot getSnapshot(File jar) {
        this.init();
        return this.snapshots.get(jar);
    }

    public void putSnapshots(Map<File, JarSnapshot> newSnapshots) {
        this.init();
        this.snapshots.putAll(newSnapshots);
        DummySerializer.writeTargetTo(this.storage, this.snapshots);
    }

    private void init() {
        if (this.snapshots == null) {
            this.snapshots = this.storage.isFile() ? (Map<Object, Object>)DummySerializer.readFrom(this.storage) : new HashMap<File, JarSnapshot>();
        }
    }
}

