/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import java.util.HashMap;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.hash.Hasher;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependencyInfoExtractor;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarArchive;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;

public class JarSnapshotter {
    private final Hasher hasher;
    private final ClassDependenciesAnalyzer analyzer;

    public JarSnapshotter(Hasher hasher, ClassDependenciesAnalyzer analyzer) {
        this.hasher = hasher;
        this.analyzer = analyzer;
    }

    public JarSnapshot createSnapshot(JarArchive jarArchive) {
        FileTree classes = jarArchive.contents;
        return this.createSnapshot(classes, new ClassDependencyInfoExtractor(this.analyzer));
    }

    JarSnapshot createSnapshot(FileTree classes, final ClassDependencyInfoExtractor extractor) {
        final HashMap<String, byte[]> hashes = new HashMap<String, byte[]>();
        classes.visit(new FileVisitor(){

            public void visitDir(FileVisitDetails dirDetails) {
            }

            public void visitFile(FileVisitDetails fileDetails) {
                extractor.visitFile(fileDetails);
                String className = fileDetails.getPath().replaceAll("/", ".").replaceAll("\\.class$", "");
                byte[] classHash = JarSnapshotter.this.hasher.hash(fileDetails.getFile());
                hashes.put(className, classHash);
            }
        });
        return new JarSnapshot(hashes, extractor.getDependencyInfo());
    }
}

