/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import java.io.File;
import java.util.HashMap;
import org.gradle.api.internal.tasks.compile.incremental.jar.ClasspathJarFinder;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarArchive;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotter;
import org.gradle.api.internal.tasks.compile.incremental.jar.LocalJarSnapshotCache;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarSnapshotsMaker {
    private static final Logger LOG = Logging.getLogger(JarSnapshotsMaker.class);
    private final LocalJarSnapshotCache jarSnapshotCache;
    private final JarSnapshotter jarSnapshotter;
    private ClasspathJarFinder classpathJarFinder;

    public JarSnapshotsMaker(LocalJarSnapshotCache jarSnapshotCache, JarSnapshotter jarSnapshotter, ClasspathJarFinder classpathJarFinder) {
        this.jarSnapshotCache = jarSnapshotCache;
        this.jarSnapshotter = jarSnapshotter;
        this.classpathJarFinder = classpathJarFinder;
    }

    public void storeJarSnapshots(Iterable<File> classpath) {
        Clock clock = new Clock();
        Iterable<JarArchive> jarArchives = this.classpathJarFinder.findJarArchives(classpath);
        HashMap<File, JarSnapshot> newSnapshots = new HashMap<File, JarSnapshot>();
        for (JarArchive jar : jarArchives) {
            newSnapshots.put(jar.file, this.jarSnapshotter.createSnapshot(jar));
        }
        this.jarSnapshotCache.putSnapshots(newSnapshots);
        LOG.lifecycle("Created and written jar snapshots in {}.", new Object[]{clock.getTime()});
    }
}

