/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependencyInfo;
import org.gradle.api.internal.tasks.compile.incremental.deps.DefaultDependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarSnapshot
implements Serializable {
    final Map<String, byte[]> hashes;
    final ClassDependencyInfo info;

    public JarSnapshot(Map<String, byte[]> hashes, ClassDependencyInfo info) {
        assert (hashes != null);
        assert (info != null);
        this.hashes = hashes;
        this.info = info;
    }

    public DependentsSet getAllClasses() {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, byte[]> cls : this.hashes.entrySet()) {
            String className = cls.getKey();
            DependentsSet dependents = this.info.getRelevantDependents(className);
            if (dependents.isDependencyToAll()) {
                return dependents;
            }
            result.add(className);
        }
        return new DefaultDependentsSet(result);
    }

    public DependentsSet getAffectedClassesSince(JarSnapshot other) {
        HashSet<String> affected = new HashSet<String>();
        for (Map.Entry<String, byte[]> otherClass : other.hashes.entrySet()) {
            String otherClassName = otherClass.getKey();
            byte[] otherClassBytes = otherClass.getValue();
            byte[] thisClsBytes = this.hashes.get(otherClassName);
            if (thisClsBytes != null && Arrays.equals(thisClsBytes, otherClassBytes)) continue;
            affected.add(otherClassName);
            DependentsSet dependents = other.info.getRelevantDependents(otherClassName);
            if (dependents.isDependencyToAll()) {
                return dependents;
            }
            affected.addAll(dependents.getDependentClasses());
        }
        return new DefaultDependentsSet(affected);
    }
}

