/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import org.gradle.api.internal.tasks.compile.incremental.deps.DefaultDependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarArchive;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotter;
import org.gradle.api.internal.tasks.compile.incremental.model.PreviousCompilation;
import org.gradle.api.tasks.incremental.InputFileDetails;

public class JarChangeDependentsFinder {
    private JarSnapshotter jarSnapshotter;
    private PreviousCompilation previousCompilation;

    public JarChangeDependentsFinder(JarSnapshotter jarSnapshotter, PreviousCompilation previousCompilation) {
        this.jarSnapshotter = jarSnapshotter;
        this.previousCompilation = previousCompilation;
    }

    public DependentsSet getActualDependents(InputFileDetails jarChangeDetails, JarArchive jarArchive) {
        JarSnapshot existing = this.previousCompilation.getJarSnapshot(jarChangeDetails.getFile());
        if (jarChangeDetails.isAdded()) {
            return new DefaultDependentsSet();
        }
        if (existing == null) {
            return new DefaultDependentsSet(true);
        }
        if (jarChangeDetails.isRemoved()) {
            DependentsSet allClasses = existing.getAllClasses();
            if (allClasses.isDependencyToAll()) {
                return allClasses;
            }
            return this.previousCompilation.getDependents(allClasses.getDependentClasses());
        }
        if (jarChangeDetails.isModified()) {
            JarSnapshot newSnapshot = this.jarSnapshotter.createSnapshot(jarArchive);
            DependentsSet affectedClasses = newSnapshot.getAffectedClassesSince(existing);
            if (affectedClasses.isDependencyToAll()) {
                return affectedClasses;
            }
            return this.previousCompilation.getDependents(affectedClasses.getDependentClasses());
        }
        throw new IllegalArgumentException("Unknown input file details provided: " + jarChangeDetails);
    }
}

