/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import java.io.File;
import java.io.IOException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependencyInfo;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependentsAccumulator;

public class ClassDependencyInfoExtractor
implements FileVisitor {
    private final ClassDependenciesAnalyzer analyzer;
    private final String packagePrefix;
    private final ClassDependentsAccumulator accumulator;

    public ClassDependencyInfoExtractor(ClassDependenciesAnalyzer analyzer) {
        this(analyzer, "");
    }

    ClassDependencyInfoExtractor(ClassDependenciesAnalyzer analyzer, String packagePrefix) {
        this.analyzer = analyzer;
        this.packagePrefix = packagePrefix;
        this.accumulator = new ClassDependentsAccumulator(packagePrefix);
    }

    public void visitDir(FileVisitDetails dirDetails) {
    }

    public void visitFile(FileVisitDetails fileDetails) {
        File file = fileDetails.getFile();
        if (!file.getName().endsWith(".class")) {
            return;
        }
        String className = fileDetails.getPath().replaceAll("/", ".").replaceAll("\\.class$", "");
        if (!className.startsWith(this.packagePrefix)) {
            return;
        }
        try {
            ClassAnalysis analysis = this.analyzer.getClassAnalysis(className, file);
            this.accumulator.addClass(className, analysis.isDependencyToAll(), analysis.getClassDependencies());
        }
        catch (IOException e) {
            throw new RuntimeException("Problems extracting class dependency from " + file, e);
        }
    }

    public ClassDependencyInfo getDependencyInfo() {
        return new ClassDependencyInfo(this.accumulator.getDependentsMap());
    }
}

