/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.deps.DefaultDependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependencyToAll;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDependencyInfo
implements Serializable {
    private final Map<String, ? extends DependentsSet> dependents;

    public ClassDependencyInfo(Map<String, ? extends DependentsSet> dependents) {
        this.dependents = dependents;
    }

    public DependentsSet getRelevantDependents(Iterable<String> classes) {
        LinkedList<String> result = new LinkedList<String>();
        for (String cls : classes) {
            DependentsSet d = this.getRelevantDependents(cls);
            if (d.isDependencyToAll()) {
                return d;
            }
            result.addAll(d.getDependentClasses());
        }
        return new DefaultDependentsSet(result);
    }

    public DependentsSet getRelevantDependents(String className) {
        DependentsSet deps = this.dependents.get(className);
        if (deps == null) {
            return new DefaultDependentsSet();
        }
        if (deps.isDependencyToAll()) {
            return new DependencyToAll();
        }
        HashSet<String> result = new HashSet<String>();
        this.recurseDependents(new HashSet<String>(), result, deps.getDependentClasses());
        result.remove(className);
        return new DefaultDependentsSet(result);
    }

    private void recurseDependents(Set<String> visited, Set<String> result, Set<String> dependentClasses) {
        for (String d : dependentClasses) {
            if (!visited.add(d)) continue;
            if (!d.contains("$")) {
                result.add(d);
            }
            DependentsSet currentDependents = this.dependents.get(d);
            this.recurseDependents(visited, result, currentDependents.getDependentClasses());
        }
    }
}

