/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.analyzer;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;

class ClassDependenciesVisitor
extends ClassVisitor {
    private static final int API = 262144;
    boolean dependentToAll;

    public ClassDependenciesVisitor() {
        super(262144);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.isAnnotationType(interfaces)) {
            this.dependentToAll = true;
        }
    }

    private boolean isAnnotationType(String[] interfaces) {
        return interfaces.length == 1 && interfaces[0].equals("java/lang/annotation/Annotation");
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (ClassDependenciesVisitor.isConstant(access) && !ClassDependenciesVisitor.isPrivate(access)) {
            this.dependentToAll = true;
        }
        return null;
    }

    private static boolean isPrivate(int access) {
        return (access & 2) != 0;
    }

    private static boolean isConstant(int access) {
        return (access & 0x10) != 0 && (access & 8) != 0;
    }
}

