/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilationInitializer;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationNotNecessary;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpecProvider;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectiveCompiler
implements Compiler<JavaCompileSpec> {
    private static final Logger LOG = Logging.getLogger(SelectiveCompiler.class);
    private final IncrementalTaskInputs inputs;
    private final CleaningJavaCompiler cleaningCompiler;
    private final RecompilationSpecProvider recompilationSpecProvider;
    private final IncrementalCompilationInitializer incrementalCompilationInitilizer;

    public SelectiveCompiler(IncrementalTaskInputs inputs, CleaningJavaCompiler cleaningCompiler, RecompilationSpecProvider recompilationSpecProvider, IncrementalCompilationInitializer compilationInitializer) {
        this.inputs = inputs;
        this.cleaningCompiler = cleaningCompiler;
        this.recompilationSpecProvider = recompilationSpecProvider;
        this.incrementalCompilationInitilizer = compilationInitializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkResult execute(JavaCompileSpec spec) {
        WorkResult workResult;
        Clock clock = new Clock();
        RecompilationSpec recompilationSpec = this.recompilationSpecProvider.provideRecompilationSpec(this.inputs);
        if (recompilationSpec.isFullRebuildNeeded()) {
            LOG.lifecycle("Detection of classes for compilation took {}. Full rebuild is needed due to a change to: {}.", new Object[]{clock.getTime(), recompilationSpec.getFullRebuildCause()});
            return this.cleaningCompiler.execute(spec);
        }
        this.incrementalCompilationInitilizer.initializeCompilation(spec, recompilationSpec.getClassNames());
        if (spec.getSource().isEmpty()) {
            LOG.lifecycle("Detection of classes for compilation took {}. No recompilation is needed!", new Object[]{clock.getTime()});
            return new RecompilationNotNecessary();
        }
        try {
            workResult = this.cleaningCompiler.getCompiler().execute(spec);
        }
        catch (Throwable throwable) {
            LOG.lifecycle("Detection of {} classes for compilation and the compilation took {}.", new Object[]{recompilationSpec.getClassNames().size(), clock.getTime()});
            throw throwable;
        }
        LOG.lifecycle("Detection of {} classes for compilation and the compilation took {}.", new Object[]{recompilationSpec.getClassNames().size(), clock.getTime()});
        return workResult;
    }
}

