/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import java.io.File;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.hash.DefaultHasher;
import org.gradle.api.internal.hash.Hasher;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.ClassDependencyInfoUpdater;
import org.gradle.api.internal.tasks.compile.incremental.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilationSupport;
import org.gradle.api.internal.tasks.compile.incremental.SourceToNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependencyInfoSerializer;
import org.gradle.api.internal.tasks.compile.incremental.jar.ClasspathJarFinder;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotsMaker;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotter;
import org.gradle.api.internal.tasks.compile.incremental.jar.LocalJarSnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpecProvider;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalJavaCompilerFactory {
    private final IncrementalCompilationSupport incrementalSupport;

    public IncrementalJavaCompilerFactory(Project project, String compileTaskPath, CleaningJavaCompiler cleaningJavaCompiler, List<Object> source) {
        ClassDependenciesAnalyzer analyzer = new ClassDependenciesAnalyzer();
        JarSnapshotter jarSnapshotter = new JarSnapshotter((Hasher)new DefaultHasher(), analyzer);
        String cacheFileBaseName = compileTaskPath.replaceAll(":", "_");
        LocalJarSnapshotCache jarSnapshotCache = new LocalJarSnapshotCache(new File(project.getBuildDir(), cacheFileBaseName + "-jar-snapshot-cache.bin"));
        ClassDependencyInfoSerializer dependencyInfoSerializer = new ClassDependencyInfoSerializer(new File(project.getBuildDir(), cacheFileBaseName + "-class-info.bin"));
        JarSnapshotsMaker jarSnapshotsMaker = new JarSnapshotsMaker(jarSnapshotCache, jarSnapshotter, new ClasspathJarFinder((FileOperations)project));
        CompilationSourceDirs sourceDirs = new CompilationSourceDirs(source);
        SourceToNameConverter sourceToNameConverter = new SourceToNameConverter(sourceDirs);
        RecompilationSpecProvider recompilationSpecProvider = new RecompilationSpecProvider(sourceToNameConverter, dependencyInfoSerializer, (FileOperations)project, jarSnapshotter, jarSnapshotCache);
        ClassDependencyInfoUpdater classDependencyInfoUpdater = new ClassDependencyInfoUpdater(dependencyInfoSerializer, (FileOperations)project, analyzer);
        this.incrementalSupport = new IncrementalCompilationSupport(jarSnapshotsMaker, dependencyInfoSerializer, (FileOperations)project, cleaningJavaCompiler, compileTaskPath, recompilationSpecProvider, classDependencyInfoUpdater, sourceDirs);
    }

    public Compiler<JavaCompileSpec> createCompiler(IncrementalTaskInputs inputs) {
        return this.incrementalSupport.prepareCompiler(inputs);
    }
}

