/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.ClassDependencyInfoUpdater;
import org.gradle.api.internal.tasks.compile.incremental.CompilationSourceDirs;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilationFinalizer;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilationInitializer;
import org.gradle.api.internal.tasks.compile.incremental.SelectiveCompiler;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependencyInfoSerializer;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotsMaker;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpecProvider;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalCompilationSupport {
    private static final Logger LOG = Logging.getLogger(IncrementalCompilationSupport.class);
    private final JarSnapshotsMaker jarSnapshotsMaker;
    private final ClassDependencyInfoSerializer dependencyInfoSerializer;
    private final FileOperations fileOperations;
    private final CleaningJavaCompiler cleaningCompiler;
    private final String displayName;
    private final RecompilationSpecProvider staleClassDetecter;
    private final ClassDependencyInfoUpdater classDependencyInfoUpdater;
    private final CompilationSourceDirs sourceDirs;

    public IncrementalCompilationSupport(JarSnapshotsMaker jarSnapshotsMaker, ClassDependencyInfoSerializer dependencyInfoSerializer, FileOperations fileOperations, CleaningJavaCompiler cleaningCompiler, String displayName, RecompilationSpecProvider staleClassDetecter, ClassDependencyInfoUpdater classDependencyInfoUpdater, CompilationSourceDirs sourceDirs) {
        this.jarSnapshotsMaker = jarSnapshotsMaker;
        this.dependencyInfoSerializer = dependencyInfoSerializer;
        this.fileOperations = fileOperations;
        this.cleaningCompiler = cleaningCompiler;
        this.displayName = displayName;
        this.staleClassDetecter = staleClassDetecter;
        this.classDependencyInfoUpdater = classDependencyInfoUpdater;
        this.sourceDirs = sourceDirs;
    }

    public Compiler<JavaCompileSpec> prepareCompiler(IncrementalTaskInputs inputs) {
        Compiler<JavaCompileSpec> compiler = this.getCompiler(inputs, this.sourceDirs);
        return new IncrementalCompilationFinalizer(compiler, this.jarSnapshotsMaker, this.classDependencyInfoUpdater);
    }

    private Compiler<JavaCompileSpec> getCompiler(IncrementalTaskInputs inputs, CompilationSourceDirs sourceDirs) {
        if (!inputs.isIncremental()) {
            LOG.lifecycle("{} - is not incremental (e.g. outputs have changed, no previous execution, etc)", new Object[]{this.displayName});
            return this.cleaningCompiler;
        }
        if (!sourceDirs.areSourceDirsKnown()) {
            LOG.lifecycle("{} - is not incremental. Unable to infer the source directories.", new Object[]{this.displayName});
            return this.cleaningCompiler;
        }
        if (!this.dependencyInfoSerializer.isInfoAvailable()) {
            LOG.lifecycle("{} - is not incremental. No class dependency data available from previous build.", new Object[]{this.displayName});
            return this.cleaningCompiler;
        }
        return new SelectiveCompiler(inputs, this.cleaningCompiler, this.staleClassDetecter, new IncrementalCompilationInitializer(this.fileOperations));
    }
}

