/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.ClassDependencyInfoUpdater;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotsMaker;
import org.gradle.api.tasks.WorkResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IncrementalCompilationFinalizer
implements Compiler<JavaCompileSpec> {
    private final Compiler<JavaCompileSpec> delegate;
    private final JarSnapshotsMaker jarSnapshotsMaker;
    private final ClassDependencyInfoUpdater dependencyInfoUpdater;

    public IncrementalCompilationFinalizer(Compiler<JavaCompileSpec> delegate, JarSnapshotsMaker jarSnapshotsMaker, ClassDependencyInfoUpdater dependencyInfoUpdater) {
        this.delegate = delegate;
        this.jarSnapshotsMaker = jarSnapshotsMaker;
        this.dependencyInfoUpdater = dependencyInfoUpdater;
    }

    @Override
    public WorkResult execute(JavaCompileSpec spec) {
        WorkResult out = this.delegate.execute(spec);
        this.dependencyInfoUpdater.updateInfo(spec, out);
        this.jarSnapshotsMaker.storeJarSnapshots(spec.getClasspath());
        return out;
    }
}

