/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependencyInfo;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependencyInfoExtractor;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependencyInfoWriter;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationNotNecessary;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.util.Clock;

public class ClassDependencyInfoUpdater {
    private static final Logger LOG = Logging.getLogger(ClassDependencyInfoUpdater.class);
    private final ClassDependencyInfoWriter writer;
    private final FileOperations fileOperations;
    private ClassDependenciesAnalyzer analyzer;

    public ClassDependencyInfoUpdater(ClassDependencyInfoWriter writer, FileOperations fileOperations, ClassDependenciesAnalyzer analyzer) {
        this.writer = writer;
        this.fileOperations = fileOperations;
        this.analyzer = analyzer;
    }

    public void updateInfo(JavaCompileSpec spec, WorkResult compilationResult) {
        if (compilationResult instanceof RecompilationNotNecessary) {
            return;
        }
        Clock clock = new Clock();
        ConfigurableFileTree tree = this.fileOperations.fileTree((Object)spec.getDestinationDir());
        ClassDependencyInfoExtractor extractor = new ClassDependencyInfoExtractor(this.analyzer);
        tree.visit((FileVisitor)extractor);
        ClassDependencyInfo info = extractor.getDependencyInfo();
        this.writer.writeInfo(info);
        LOG.lifecycle("Performed class dependency analysis in {}, wrote results into {}", new Object[]{clock.getTime(), this.writer});
    }
}

