/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.internal.tasks.compile.CompileSpec;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.internal.tasks.compile.daemon.CompileResult;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemon;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonFactory;
import org.gradle.api.internal.tasks.compile.daemon.DaemonForkOptions;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classloader.DefaultClassLoaderFactory;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.MutableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.io.ClassLoaderObjectInputStream;
import org.gradle.util.GUtil;

public class InProcessCompilerDaemonFactory
implements CompilerDaemonFactory {
    private static final InProcessCompilerDaemonFactory INSTANCE = new InProcessCompilerDaemonFactory();
    private final ClassLoaderFactory classLoaderFactory = new DefaultClassLoaderFactory();

    public static InProcessCompilerDaemonFactory getInstance() {
        return INSTANCE;
    }

    public CompilerDaemon getDaemon(File workingDir, final DaemonForkOptions forkOptions) {
        return new CompilerDaemon(){

            @Override
            public <T extends CompileSpec> CompileResult execute(Compiler<T> compiler, T spec) {
                ClassLoader groovyClassLoader = InProcessCompilerDaemonFactory.this.classLoaderFactory.createIsolatedClassLoader((ClassPath)new DefaultClassPath(forkOptions.getClasspath()));
                FilteringClassLoader filteredGroovy = InProcessCompilerDaemonFactory.this.classLoaderFactory.createFilteringClassLoader(groovyClassLoader);
                for (String packageName : forkOptions.getSharedPackages()) {
                    filteredGroovy.allowPackage(packageName);
                }
                MutableURLClassLoader workerClassLoader = new MutableURLClassLoader((ClassLoader)filteredGroovy, (Collection)ClasspathUtil.getClasspath((ClassLoader)compiler.getClass().getClassLoader()));
                try {
                    byte[] serializedWorker = GUtil.serialize(new Worker(compiler, spec, null));
                    ClassLoaderObjectInputStream inputStream = new ClassLoaderObjectInputStream((InputStream)new ByteArrayInputStream(serializedWorker), (ClassLoader)workerClassLoader);
                    Callable worker = (Callable)inputStream.readObject();
                    Object result = worker.call();
                    byte[] serializedResult = GUtil.serialize(result);
                    inputStream = new ClassLoaderObjectInputStream((InputStream)new ByteArrayInputStream(serializedResult), this.getClass().getClassLoader());
                    return (CompileResult)inputStream.readObject();
                }
                catch (Exception e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Worker<T extends CompileSpec>
    implements Callable<Object>,
    Serializable {
        private final Compiler<T> compiler;
        private final T spec;

        private Worker(Compiler<T> compiler, T spec) {
            this.compiler = compiler;
            this.spec = spec;
        }

        @Override
        public Object call() throws Exception {
            return new CompileResult(this.compiler.execute(this.spec).getDidWork(), null);
        }

        /* synthetic */ Worker(Compiler x0, CompileSpec x1, 1 x2) {
            this(x0, x1);
        }
    }
}

