/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import java.io.File;
import java.util.Collections;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.daemon.CompileResult;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemon;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonManager;
import org.gradle.api.internal.tasks.compile.daemon.DaemonForkOptions;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonJavaCompiler
implements Compiler<JavaCompileSpec> {
    private final ProjectInternal project;
    private final Compiler<JavaCompileSpec> delegate;
    private final CompilerDaemonManager compilerDaemonManager;

    public DaemonJavaCompiler(ProjectInternal project, Compiler<JavaCompileSpec> delegate, CompilerDaemonManager compilerDaemonManager) {
        this.project = project;
        this.delegate = delegate;
        this.compilerDaemonManager = compilerDaemonManager;
    }

    @Override
    public WorkResult execute(JavaCompileSpec spec) {
        ForkOptions forkOptions = spec.getCompileOptions().getForkOptions();
        DaemonForkOptions daemonForkOptions = new DaemonForkOptions(forkOptions.getMemoryInitialSize(), forkOptions.getMemoryMaximumSize(), forkOptions.getJvmArgs(), Collections.<File>emptyList(), Collections.singleton("com.sun.tools.javac"));
        CompilerDaemon daemon = this.compilerDaemonManager.getDaemon(this.project.getRootProject().getProjectDir(), daemonForkOptions);
        CompileResult result = daemon.execute(this.delegate, spec);
        if (result.isSuccess()) {
            return result;
        }
        throw UncheckedException.throwAsUncheckedException((Throwable)result.getException());
    }
}

