/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.daemon.CompileResult;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemon;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonFactory;
import org.gradle.api.internal.tasks.compile.daemon.DaemonForkOptions;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.api.tasks.compile.GroovyForkOptions;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonGroovyCompiler
implements Compiler<GroovyJavaJointCompileSpec> {
    private final ProjectInternal project;
    private final Compiler<GroovyJavaJointCompileSpec> delegate;
    private final CompilerDaemonFactory daemonFactory;

    public DaemonGroovyCompiler(ProjectInternal project, Compiler<GroovyJavaJointCompileSpec> delegate, CompilerDaemonFactory daemonFactory) {
        this.project = project;
        this.delegate = delegate;
        this.daemonFactory = daemonFactory;
    }

    @Override
    public WorkResult execute(GroovyJavaJointCompileSpec spec) {
        DaemonForkOptions daemonForkOptions = this.createDaemonForkOptions(spec);
        CompilerDaemon daemon = this.daemonFactory.getDaemon(this.project.getRootProject().getProjectDir(), daemonForkOptions);
        CompileResult result = daemon.execute(this.delegate, spec);
        if (result.isSuccess()) {
            return result;
        }
        throw UncheckedException.throwAsUncheckedException((Throwable)result.getException());
    }

    private DaemonForkOptions createDaemonForkOptions(GroovyJavaJointCompileSpec spec) {
        return this.createJavaForkOptions(spec).mergeWith(this.createGroovyForkOptions(spec));
    }

    private DaemonForkOptions createJavaForkOptions(GroovyJavaJointCompileSpec spec) {
        ForkOptions options = spec.getCompileOptions().getForkOptions();
        return new DaemonForkOptions(options.getMemoryInitialSize(), options.getMemoryMaximumSize(), options.getJvmArgs());
    }

    private DaemonForkOptions createGroovyForkOptions(GroovyJavaJointCompileSpec spec) {
        GroovyForkOptions options = spec.getGroovyCompileOptions().getForkOptions();
        List antFiles = ((ClassPathRegistry)this.project.getServices().get(ClassPathRegistry.class)).getClassPath("ANT").getAsFiles();
        Iterable groovyFiles = Iterables.concat(spec.getGroovyClasspath(), (Iterable)antFiles);
        List<String> groovyPackages = Arrays.asList("groovy", "org.codehaus.groovy", "groovyjarjarantlr", "groovyjarjarasm", "groovyjarjarcommonscli", "org.apache.tools.ant", "com.sun.tools.javac");
        return new DaemonForkOptions(options.getMemoryInitialSize(), options.getMemoryMaximumSize(), options.getJvmArgs(), groovyFiles, groovyPackages);
    }
}

