/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.compile.CompileSpec;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.internal.tasks.compile.daemon.CompileResult;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonClientProtocol;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonServerProtocol;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.UncheckedException;
import org.gradle.process.internal.WorkerProcessContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerDaemonServer
implements Action<WorkerProcessContext>,
CompilerDaemonServerProtocol,
Serializable {
    private static final Logger LOGGER = Logging.getLogger(CompilerDaemonServer.class);
    private volatile CompilerDaemonClientProtocol client;
    private volatile CountDownLatch stop;

    public void execute(WorkerProcessContext context) {
        this.stop = new CountDownLatch(1);
        this.client = (CompilerDaemonClientProtocol)context.getServerConnection().addOutgoing(CompilerDaemonClientProtocol.class);
        context.getServerConnection().addIncoming(CompilerDaemonServerProtocol.class, (Object)this);
        context.getServerConnection().connect();
        try {
            this.stop.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public <T extends CompileSpec> void execute(Compiler<T> compiler, T spec) {
        try {
            LOGGER.info("Executing {} in compiler daemon.", compiler);
            WorkResult result = compiler.execute(spec);
            LOGGER.info("Successfully executed {} in compiler daemon.", compiler);
            this.client.executed(new CompileResult(result.getDidWork(), null));
        }
        catch (Throwable t) {
            LOGGER.info("Exception executing {} in compiler daemon: {}.", compiler, (Object)t);
            this.client.executed(new CompileResult(true, t));
        }
    }

    public void stop() {
        this.stop.countDown();
    }
}

