/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalizingGroovyCompiler
implements Compiler<GroovyJavaJointCompileSpec> {
    private static final Logger LOGGER = Logging.getLogger(NormalizingGroovyCompiler.class);
    private final Compiler<GroovyJavaJointCompileSpec> delegate;

    public NormalizingGroovyCompiler(Compiler<GroovyJavaJointCompileSpec> delegate) {
        this.delegate = delegate;
    }

    @Override
    public WorkResult execute(GroovyJavaJointCompileSpec spec) {
        this.resolveAndFilterSourceFiles(spec);
        this.resolveClasspath(spec);
        this.resolveNonStringsInCompilerArgs(spec);
        this.logSourceFiles(spec);
        this.logCompilerArguments(spec);
        return this.delegateAndHandleErrors(spec);
    }

    private void resolveAndFilterSourceFiles(final GroovyJavaJointCompileSpec spec) {
        FileCollection filtered = spec.getSource().filter((Spec)new Spec<File>(){

            public boolean isSatisfiedBy(File element) {
                for (String fileExtension : spec.getGroovyCompileOptions().getFileExtensions()) {
                    if (!element.getName().endsWith("." + fileExtension)) continue;
                    return true;
                }
                return false;
            }
        });
        spec.setSource((FileCollection)new SimpleFileCollection((Collection)filtered.getFiles()));
    }

    private void resolveClasspath(GroovyJavaJointCompileSpec spec) {
        spec.setClasspath((Iterable<File>)new SimpleFileCollection((Collection)Lists.newArrayList(spec.getClasspath())));
        spec.setGroovyClasspath((Iterable<File>)new SimpleFileCollection((Collection)Lists.newArrayList(spec.getGroovyClasspath())));
    }

    private void resolveNonStringsInCompilerArgs(GroovyJavaJointCompileSpec spec) {
        spec.getCompileOptions().setCompilerArgs(CollectionUtils.toStringList(spec.getCompileOptions().getCompilerArgs()));
    }

    private void logSourceFiles(GroovyJavaJointCompileSpec spec) {
        if (!spec.getGroovyCompileOptions().isListFiles()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Source files to be compiled:");
        for (File file : spec.getSource()) {
            builder.append('\n');
            builder.append(file);
        }
        LOGGER.quiet(builder.toString());
    }

    private void logCompilerArguments(GroovyJavaJointCompileSpec spec) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        List<String> compilerArgs = new JavaCompilerArgumentsBuilder(spec).includeLauncherOptions(true).includeSourceFiles(true).build();
        String joinedArgs = Joiner.on((char)' ').join(compilerArgs);
        LOGGER.debug("Java compiler arguments: {}", (Object)joinedArgs);
    }

    private WorkResult delegateAndHandleErrors(GroovyJavaJointCompileSpec spec) {
        try {
            return this.delegate.execute(spec);
        }
        catch (CompilationFailedException e) {
            if (spec.getCompileOptions().isFailOnError()) {
                throw e;
            }
            LOGGER.debug("Ignoring compilation failure.");
            return new SimpleWorkResult(false);
        }
    }
}

