/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.ForkOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCompilerArgumentsBuilder {
    private final JavaCompileSpec spec;
    private boolean includeLauncherOptions;
    private boolean includeMainOptions = true;
    private boolean includeClasspath = true;
    private boolean includeSourceFiles;
    private List<String> args;

    public JavaCompilerArgumentsBuilder(JavaCompileSpec spec) {
        this.spec = spec;
    }

    public JavaCompilerArgumentsBuilder includeLauncherOptions(boolean flag) {
        this.includeLauncherOptions = flag;
        return this;
    }

    public JavaCompilerArgumentsBuilder includeMainOptions(boolean flag) {
        this.includeMainOptions = flag;
        return this;
    }

    public JavaCompilerArgumentsBuilder includeClasspath(boolean flag) {
        this.includeClasspath = flag;
        return this;
    }

    public JavaCompilerArgumentsBuilder includeSourceFiles(boolean flag) {
        this.includeSourceFiles = flag;
        return this;
    }

    public List<String> build() {
        this.args = new ArrayList<String>();
        this.addLauncherOptions();
        this.addMainOptions();
        this.addClasspath();
        this.addSourceFiles();
        return this.args;
    }

    private void addLauncherOptions() {
        if (!this.includeLauncherOptions) {
            return;
        }
        ForkOptions forkOptions = this.spec.getCompileOptions().getForkOptions();
        if (forkOptions.getMemoryInitialSize() != null) {
            this.args.add("-J-Xms" + forkOptions.getMemoryInitialSize().trim());
        }
        if (forkOptions.getMemoryMaximumSize() != null) {
            this.args.add("-J-Xmx" + forkOptions.getMemoryMaximumSize().trim());
        }
        if (forkOptions.getJvmArgs() != null) {
            this.args.addAll(forkOptions.getJvmArgs());
        }
    }

    private void addMainOptions() {
        CompileOptions compileOptions;
        File destinationDir;
        String targetCompatibility;
        if (!this.includeMainOptions) {
            return;
        }
        String sourceCompatibility = this.spec.getSourceCompatibility();
        if (sourceCompatibility != null && !JavaVersion.current().equals((Object)JavaVersion.toVersion((Object)sourceCompatibility))) {
            this.args.add("-source");
            this.args.add(sourceCompatibility);
        }
        if ((targetCompatibility = this.spec.getTargetCompatibility()) != null && !JavaVersion.current().equals((Object)JavaVersion.toVersion((Object)targetCompatibility))) {
            this.args.add("-target");
            this.args.add(targetCompatibility);
        }
        if ((destinationDir = this.spec.getDestinationDir()) != null) {
            this.args.add("-d");
            this.args.add(destinationDir.getPath());
        }
        if ((compileOptions = this.spec.getCompileOptions()).isVerbose()) {
            this.args.add("-verbose");
        }
        if (compileOptions.isDeprecation()) {
            this.args.add("-deprecation");
        }
        if (!compileOptions.isWarnings()) {
            this.args.add("-nowarn");
        }
        if (compileOptions.isDebug()) {
            if (compileOptions.getDebugOptions().getDebugLevel() != null) {
                this.args.add("-g:" + compileOptions.getDebugOptions().getDebugLevel().trim());
            } else {
                this.args.add("-g");
            }
        } else {
            this.args.add("-g:none");
        }
        if (compileOptions.getEncoding() != null) {
            this.args.add("-encoding");
            this.args.add(compileOptions.getEncoding());
        }
        if (compileOptions.getBootClasspath() != null) {
            this.args.add("-bootclasspath");
            this.args.add(compileOptions.getBootClasspath());
        }
        if (compileOptions.getExtensionDirs() != null) {
            this.args.add("-extdirs");
            this.args.add(compileOptions.getExtensionDirs());
        }
        if (compileOptions.getCompilerArgs() != null) {
            this.args.addAll(compileOptions.getCompilerArgs());
        }
    }

    private void addClasspath() {
        if (!this.includeClasspath) {
            return;
        }
        Iterable<File> classpath = this.spec.getClasspath();
        if (classpath != null && classpath.iterator().hasNext()) {
            this.args.add("-classpath");
            this.args.add(this.toFileCollection(classpath).getAsPath());
        }
    }

    private void addSourceFiles() {
        if (!this.includeSourceFiles) {
            return;
        }
        for (File file : this.spec.getSource()) {
            this.args.add(file.getPath());
        }
    }

    private FileCollection toFileCollection(Iterable<File> classpath) {
        if (classpath instanceof FileCollection) {
            return (FileCollection)classpath;
        }
        return new SimpleFileCollection((Collection)Lists.newArrayList(classpath));
    }
}

