/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.ApiGroovyCompiler;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompilerFactory;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.NormalizingGroovyCompiler;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonFactory;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonManager;
import org.gradle.api.internal.tasks.compile.daemon.DaemonGroovyCompiler;
import org.gradle.api.internal.tasks.compile.daemon.InProcessCompilerDaemonFactory;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.GroovyCompileOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyCompilerFactory {
    private final ProjectInternal project;
    private final DefaultJavaCompilerFactory javaCompilerFactory;
    private final CompilerDaemonManager compilerDaemonManager;
    private final InProcessCompilerDaemonFactory inProcessCompilerDaemonFactory;

    public GroovyCompilerFactory(ProjectInternal project, DefaultJavaCompilerFactory javaCompilerFactory, CompilerDaemonManager compilerDaemonManager, InProcessCompilerDaemonFactory inProcessCompilerDaemonFactory) {
        this.project = project;
        this.javaCompilerFactory = javaCompilerFactory;
        this.compilerDaemonManager = compilerDaemonManager;
        this.inProcessCompilerDaemonFactory = inProcessCompilerDaemonFactory;
    }

    Compiler<GroovyJavaJointCompileSpec> create(GroovyCompileOptions groovyOptions, CompileOptions javaOptions) {
        this.javaCompilerFactory.setJointCompilation(true);
        Compiler<JavaCompileSpec> javaCompiler = this.javaCompilerFactory.create(javaOptions);
        Compiler<GroovyJavaJointCompileSpec> groovyCompiler = new ApiGroovyCompiler(javaCompiler);
        CompilerDaemonFactory daemonFactory = groovyOptions.isFork() ? this.compilerDaemonManager : this.inProcessCompilerDaemonFactory;
        groovyCompiler = new DaemonGroovyCompiler(this.project, groovyCompiler, daemonFactory);
        return new NormalizingGroovyCompiler(groovyCompiler);
    }
}

