/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import java.io.Serializable;
import org.gradle.api.internal.file.DefaultTemporaryFileProvider;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.CommandLineJavaCompiler;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerFactory;
import org.gradle.api.internal.tasks.compile.NormalizingJavaCompiler;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonManager;
import org.gradle.api.internal.tasks.compile.daemon.DaemonJavaCompiler;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavaCompilerFactory
implements JavaCompilerFactory {
    private final ProjectInternal project;
    private final JavaCompilerFactory inProcessCompilerFactory;
    private final CompilerDaemonManager compilerDaemonManager;
    private boolean jointCompilation;

    public DefaultJavaCompilerFactory(ProjectInternal project, JavaCompilerFactory inProcessCompilerFactory, CompilerDaemonManager compilerDaemonManager) {
        this.project = project;
        this.inProcessCompilerFactory = inProcessCompilerFactory;
        this.compilerDaemonManager = compilerDaemonManager;
    }

    public void setJointCompilation(boolean flag) {
        this.jointCompilation = flag;
    }

    @Override
    public Compiler<JavaCompileSpec> create(CompileOptions options) {
        NormalizingJavaCompiler result = this.createTargetCompiler(options);
        if (!this.jointCompilation) {
            result = new NormalizingJavaCompiler(result);
        }
        return result;
    }

    private Compiler<JavaCompileSpec> createTargetCompiler(CompileOptions options) {
        if (options.isFork() && options.getForkOptions().getExecutable() != null) {
            return new CommandLineJavaCompiler(this.createSerializableTempFileProvider(), this.project.getProjectDir());
        }
        Compiler<JavaCompileSpec> compiler = this.inProcessCompilerFactory.create(options);
        if (options.isFork() && !this.jointCompilation) {
            return new DaemonJavaCompiler(this.project, compiler, this.compilerDaemonManager);
        }
        return compiler;
    }

    private TemporaryFileProvider createSerializableTempFileProvider() {
        return new DefaultTemporaryFileProvider((Factory)new FileFactory(this.project.getBuildDir()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileFactory
    implements Factory<File>,
    Serializable {
        private final File file;

        private FileFactory(File file) {
            this.file = file;
        }

        public File create() {
            return this.file;
        }
    }
}

