/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import java.io.Serializable;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.internal.tasks.compile.CommandLineJavaCompilerArgumentsGenerator;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.CompileSpecToArguments;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.internal.tasks.compile.ExecSpecBackedArgCollector;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineJavaCompiler
implements Compiler<JavaCompileSpec>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandLineJavaCompiler.class);
    private final CompileSpecToArguments<JavaCompileSpec> argumentsGenerator;
    private final File workingDir;

    public CommandLineJavaCompiler(TemporaryFileProvider tempFileProvider, File workingDir) {
        this.argumentsGenerator = new CommandLineJavaCompilerArgumentsGenerator(tempFileProvider);
        this.workingDir = workingDir;
    }

    @Override
    public WorkResult execute(JavaCompileSpec spec) {
        String executable = spec.getCompileOptions().getForkOptions().getExecutable();
        LOGGER.info("Compiling with Java command line compiler '{}'.", (Object)executable);
        ExecHandle handle = this.createCompilerHandle(executable, spec);
        this.executeCompiler(handle);
        return new SimpleWorkResult(true);
    }

    private ExecHandle createCompilerHandle(String executable, JavaCompileSpec spec) {
        ExecHandleBuilder builder = new ExecHandleBuilder();
        builder.setWorkingDir((Object)this.workingDir);
        builder.setExecutable((Object)executable);
        this.argumentsGenerator.collectArguments(spec, new ExecSpecBackedArgCollector((ExecSpec)builder));
        builder.setIgnoreExitValue(true);
        return builder.build();
    }

    private void executeCompiler(ExecHandle handle) {
        handle.start();
        ExecResult result = handle.waitForFinish();
        if (result.getExitValue() != 0) {
            throw new CompilationFailedException(result.getExitValue());
        }
    }
}

