/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import org.gradle.api.AntBuilder;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.tasks.compile.AntDependsStaleClassCleaner;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompilerSupport;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.internal.Factory;
import org.gradle.language.jvm.internal.SimpleStaleClassCleaner;
import org.gradle.language.jvm.internal.StaleClassCleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleaningJavaCompiler
extends CleaningJavaCompilerSupport<JavaCompileSpec>
implements Compiler<JavaCompileSpec> {
    private final Compiler<JavaCompileSpec> compiler;
    private final Factory<AntBuilder> antBuilderFactory;
    private final TaskOutputsInternal taskOutputs;

    public CleaningJavaCompiler(Compiler<JavaCompileSpec> compiler, Factory<AntBuilder> antBuilderFactory, TaskOutputsInternal taskOutputs) {
        this.compiler = compiler;
        this.antBuilderFactory = antBuilderFactory;
        this.taskOutputs = taskOutputs;
    }

    @Override
    public Compiler<JavaCompileSpec> getCompiler() {
        return this.compiler;
    }

    @Override
    protected StaleClassCleaner createCleaner(JavaCompileSpec spec) {
        if (spec.getCompileOptions().isUseDepend()) {
            AntDependsStaleClassCleaner cleaner = new AntDependsStaleClassCleaner(this.antBuilderFactory, spec.getCompileOptions());
            cleaner.setDependencyCacheDir(spec.getDependencyCacheDir());
            return cleaner;
        }
        return new SimpleStaleClassCleaner(this.taskOutputs);
    }
}

