/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.PrintWriter;
import java.util.regex.Pattern;
import org.gradle.api.Transformer;
import org.gradle.api.internal.tasks.compile.ArgCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgWriter
implements ArgCollector {
    private static final Pattern WHITESPACE = Pattern.compile("\\s");
    private final PrintWriter writer;
    private final boolean backslashEscape;

    private ArgWriter(PrintWriter writer, boolean backslashEscape) {
        this.writer = writer;
        this.backslashEscape = backslashEscape;
    }

    public static ArgWriter unixStyle(PrintWriter writer) {
        return new ArgWriter(writer, true);
    }

    public static Transformer<ArgWriter, PrintWriter> unixStyleFactory() {
        return new Transformer<ArgWriter, PrintWriter>(){

            public ArgWriter transform(PrintWriter original) {
                return ArgWriter.unixStyle(original);
            }
        };
    }

    public static ArgWriter windowsStyle(PrintWriter writer) {
        return new ArgWriter(writer, false);
    }

    public static Transformer<ArgWriter, PrintWriter> windowsStyleFactory() {
        return new Transformer<ArgWriter, PrintWriter>(){

            public ArgWriter transform(PrintWriter original) {
                return ArgWriter.windowsStyle(original);
            }
        };
    }

    @Override
    public ArgWriter args(Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (i > 0) {
                this.writer.print(' ');
            }
            String str = arg.toString();
            if (this.backslashEscape) {
                str = str.replace("\\", "\\\\").replace("\"", "\\\"");
            }
            if (WHITESPACE.matcher(str).find()) {
                this.writer.print('\"');
                this.writer.print(str);
                this.writer.print('\"');
                continue;
            }
            this.writer.print(str);
        }
        this.writer.println();
        return this;
    }

    @Override
    public ArgCollector args(Iterable<?> args) {
        for (Object arg : args) {
            this.args(arg);
        }
        return this;
    }
}

