/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.collect.Iterables;
import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit;
import org.codehaus.groovy.tools.javac.JavaCompiler;
import org.codehaus.groovy.tools.javac.JavaCompilerFactory;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.Compiler;
import org.gradle.api.internal.tasks.compile.GroovyCompileTransformingClassLoader;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiGroovyCompiler
implements Compiler<GroovyJavaJointCompileSpec>,
Serializable {
    private final Compiler<JavaCompileSpec> javaCompiler;

    public ApiGroovyCompiler(Compiler<JavaCompileSpec> javaCompiler) {
        this.javaCompiler = javaCompiler;
    }

    @Override
    public WorkResult execute(final GroovyJavaJointCompileSpec spec) {
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setVerbose(spec.getGroovyCompileOptions().isVerbose());
        configuration.setSourceEncoding(spec.getGroovyCompileOptions().getEncoding());
        configuration.setTargetBytecode(spec.getTargetCompatibility());
        configuration.setTargetDirectory(spec.getDestinationDir());
        this.canonicalizeValues(spec.getGroovyCompileOptions().getOptimizationOptions());
        try {
            configuration.setOptimizationOptions(spec.getGroovyCompileOptions().getOptimizationOptions());
        }
        catch (NoSuchMethodError ignored) {
            // empty catch block
        }
        HashMap<String, Comparable<File>> jointCompilationOptions = new HashMap<String, Comparable<File>>();
        jointCompilationOptions.put("stubDir", spec.getGroovyCompileOptions().getStubDir());
        jointCompilationOptions.put("keepStubs", Boolean.valueOf(spec.getGroovyCompileOptions().isKeepStubs()));
        configuration.setJointCompilationOptions(jointCompilationOptions);
        spec.setClasspath(Iterables.concat(spec.getClasspath(), Collections.singleton(spec.getDestinationDir())));
        GroovyCompileTransformingClassLoader classPathLoader = new GroovyCompileTransformingClassLoader((ClassPath)new DefaultClassPath(spec.getClasspath()));
        GroovyClassLoader compileClasspathClassLoader = new GroovyClassLoader((ClassLoader)((Object)classPathLoader), null);
        FilteringClassLoader groovyCompilerClassLoader = new FilteringClassLoader(GroovyClassLoader.class.getClassLoader());
        groovyCompilerClassLoader.allowPackage("org.codehaus.groovy");
        groovyCompilerClassLoader.allowPackage("groovy");
        groovyCompilerClassLoader.disallowClass("groovy.util.GroovyTestCase");
        groovyCompilerClassLoader.disallowClass("groovy.servlet.GroovyServlet");
        final GroovyClassLoader astTransformClassLoader = new GroovyClassLoader((ClassLoader)groovyCompilerClassLoader, null);
        for (File file : spec.getClasspath()) {
            astTransformClassLoader.addClasspath(file.getPath());
        }
        JavaAwareCompilationUnit unit = new JavaAwareCompilationUnit(configuration, compileClasspathClassLoader){

            public GroovyClassLoader getTransformLoader() {
                return astTransformClassLoader;
            }
        };
        unit.addSources((File[])Iterables.toArray((Iterable)spec.getSource(), File.class));
        unit.setCompilerFactory(new JavaCompilerFactory(){

            public JavaCompiler createCompiler(final CompilerConfiguration config) {
                return new JavaCompiler(){

                    public void compile(List<String> files, CompilationUnit cu) {
                        spec.setSource(spec.getSource().filter((Spec)new Spec<File>(){

                            public boolean isSatisfiedBy(File file) {
                                return file.getName().endsWith(".java");
                            }
                        }));
                        spec.getCompileOptions().getCompilerArgs().add("-sourcepath");
                        spec.getCompileOptions().getCompilerArgs().add(((File)config.getJointCompilationOptions().get("stubDir")).getAbsolutePath());
                        try {
                            ApiGroovyCompiler.this.javaCompiler.execute(spec);
                        }
                        catch (CompilationFailedException e) {
                            cu.getErrorCollector().addFatalError((Message)new SimpleMessage(e.getMessage(), (ProcessingUnit)cu));
                        }
                    }
                };
            }
        });
        try {
            unit.compile();
        }
        catch (org.codehaus.groovy.control.CompilationFailedException e) {
            System.err.println(e.getMessage());
            throw new CompilationFailedException();
        }
        return new SimpleWorkResult(true);
    }

    private void canonicalizeValues(Map<String, Boolean> options) {
        for (String key : options.keySet()) {
            boolean value = options.get(key);
            options.put(key, value);
        }
    }
}

