/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.jvm;

import java.io.File;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.jvm.ClassDirectoryBinaryNamingScheme;
import org.gradle.api.jvm.ClassDirectoryBinary;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.runtime.base.internal.AbstractBuildableModelElement;
import org.gradle.runtime.base.internal.BinaryInternal;
import org.gradle.runtime.base.internal.BinaryNamingScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassDirectoryBinary
extends AbstractBuildableModelElement
implements ClassDirectoryBinary,
BinaryInternal {
    private final BinaryNamingScheme namingScheme;
    private final DomainObjectCollection<LanguageSourceSet> source = new DefaultDomainObjectSet(LanguageSourceSet.class);
    private final String name;
    private File classesDir;
    private File resourcesDir;

    public DefaultClassDirectoryBinary(String name) {
        this.name = name;
        this.namingScheme = new ClassDirectoryBinaryNamingScheme(this.removeClassesSuffix(name));
    }

    private String removeClassesSuffix(String name) {
        if (name.endsWith("Classes")) {
            return name.substring(0, name.length() - 7);
        }
        return name;
    }

    public BinaryNamingScheme getNamingScheme() {
        return this.namingScheme;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public File getClassesDir() {
        return this.classesDir;
    }

    @Override
    public void setClassesDir(File classesDir) {
        this.classesDir = classesDir;
    }

    @Override
    public File getResourcesDir() {
        return this.resourcesDir;
    }

    @Override
    public void setResourcesDir(File resourcesDir) {
        this.resourcesDir = resourcesDir;
    }

    @Override
    public DomainObjectCollection<LanguageSourceSet> getSource() {
        return this.source;
    }

    public String getDisplayName() {
        return this.namingScheme.getDescription();
    }

    public String toString() {
        return this.namingScheme.getDescription();
    }
}

