/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.project;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gradle.mvn3.org.apache.maven.RepositoryUtils;
import org.gradle.mvn3.org.apache.maven.artifact.Artifact;
import org.gradle.mvn3.org.apache.maven.model.DependencyManagement;
import org.gradle.mvn3.org.apache.maven.model.InputLocation;
import org.gradle.mvn3.org.apache.maven.model.InputSource;
import org.gradle.mvn3.org.apache.maven.project.DefaultDependencyResolutionResult;
import org.gradle.mvn3.org.apache.maven.project.DependencyResolutionException;
import org.gradle.mvn3.org.apache.maven.project.DependencyResolutionRequest;
import org.gradle.mvn3.org.apache.maven.project.DependencyResolutionResult;
import org.gradle.mvn3.org.apache.maven.project.MavenProject;
import org.gradle.mvn3.org.apache.maven.project.ProjectDependenciesResolver;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Component;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Requirement;
import org.gradle.mvn3.org.codehaus.plexus.logging.Logger;
import org.gradle.mvn3.org.codehaus.plexus.util.StringUtils;
import org.gradle.mvn3.org.sonatype.aether.RepositorySystem;
import org.gradle.mvn3.org.sonatype.aether.RepositorySystemSession;
import org.gradle.mvn3.org.sonatype.aether.RequestTrace;
import org.gradle.mvn3.org.sonatype.aether.artifact.ArtifactType;
import org.gradle.mvn3.org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.gradle.mvn3.org.sonatype.aether.collection.CollectRequest;
import org.gradle.mvn3.org.sonatype.aether.collection.DependencyCollectionException;
import org.gradle.mvn3.org.sonatype.aether.graph.Dependency;
import org.gradle.mvn3.org.sonatype.aether.graph.DependencyFilter;
import org.gradle.mvn3.org.sonatype.aether.graph.DependencyNode;
import org.gradle.mvn3.org.sonatype.aether.graph.DependencyVisitor;
import org.gradle.mvn3.org.sonatype.aether.resolution.ArtifactResult;
import org.gradle.mvn3.org.sonatype.aether.resolution.DependencyRequest;
import org.gradle.mvn3.org.sonatype.aether.util.DefaultRequestTrace;
import org.gradle.mvn3.org.sonatype.aether.util.artifact.ArtifacIdUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ProjectDependenciesResolver.class)
public class DefaultProjectDependenciesResolver
implements ProjectDependenciesResolver {
    @Requirement
    private Logger logger;
    @Requirement
    private RepositorySystem repoSystem;

    @Override
    public DependencyResolutionResult resolve(DependencyResolutionRequest request) throws DependencyResolutionException {
        DependencyNode node;
        DependencyManagement depMngt;
        RequestTrace trace = DefaultRequestTrace.newChild(null, (Object)request);
        DefaultDependencyResolutionResult result = new DefaultDependencyResolutionResult();
        MavenProject project = request.getMavenProject();
        RepositorySystemSession session = request.getRepositorySession();
        DependencyFilter filter = request.getResolutionFilter();
        ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
        CollectRequest collect = new CollectRequest();
        collect.setRequestContext("project");
        collect.setRepositories(project.getRemoteProjectRepositories());
        if (project.getDependencyArtifacts() == null) {
            for (org.gradle.mvn3.org.apache.maven.model.Dependency dependency : project.getDependencies()) {
                if (StringUtils.isEmpty((String)dependency.getGroupId()) || StringUtils.isEmpty((String)dependency.getArtifactId()) || StringUtils.isEmpty((String)dependency.getVersion())) continue;
                collect.addDependency(RepositoryUtils.toDependency(dependency, stereotypes));
            }
        } else {
            HashMap<String, org.gradle.mvn3.org.apache.maven.model.Dependency> dependencies = new HashMap<String, org.gradle.mvn3.org.apache.maven.model.Dependency>();
            for (org.gradle.mvn3.org.apache.maven.model.Dependency dependency : project.getDependencies()) {
                ArtifactType type;
                String classifier = dependency.getClassifier();
                if (classifier == null && (type = stereotypes.get(dependency.getType())) != null) {
                    classifier = type.getClassifier();
                }
                String key = ArtifacIdUtils.toVersionlessId((String)dependency.getGroupId(), (String)dependency.getArtifactId(), (String)dependency.getType(), (String)classifier);
                dependencies.put(key, dependency);
            }
            Iterator<Object> i$ = project.getDependencyArtifacts().iterator();
            while (i$.hasNext()) {
                Artifact artifact;
                String key = (artifact = (Artifact)i$.next()).getDependencyConflictId();
                org.gradle.mvn3.org.apache.maven.model.Dependency dependency = (org.gradle.mvn3.org.apache.maven.model.Dependency)dependencies.get(key);
                List exclusions = dependency != null ? dependency.getExclusions() : null;
                Dependency dep = RepositoryUtils.toDependency(artifact, exclusions);
                if (!"system".equals(dep.getScope()) && dep.getArtifact().getFile() != null) {
                    org.gradle.mvn3.org.sonatype.aether.artifact.Artifact art = dep.getArtifact();
                    art = art.setFile(null).setVersion(art.getBaseVersion());
                    dep = dep.setArtifact(art);
                }
                collect.addDependency(dep);
            }
        }
        if ((depMngt = project.getDependencyManagement()) != null) {
            for (org.gradle.mvn3.org.apache.maven.model.Dependency dependency : depMngt.getDependencies()) {
                collect.addManagedDependency(RepositoryUtils.toDependency(dependency, stereotypes));
            }
        }
        DependencyRequest depRequest = new DependencyRequest(collect, filter);
        depRequest.setTrace(trace);
        try {
            collect.setTrace(DefaultRequestTrace.newChild((RequestTrace)trace, (Object)depRequest));
            node = this.repoSystem.collectDependencies(session, collect).getRoot();
            result.setDependencyGraph(node);
        }
        catch (DependencyCollectionException e) {
            result.setDependencyGraph(e.getResult().getRoot());
            result.setCollectionErrors(e.getResult().getExceptions());
            throw new DependencyResolutionException(result, "Could not resolve dependencies for project " + project.getId() + ": " + e.getMessage(), e);
        }
        depRequest.setRoot(node);
        if (this.logger.isWarnEnabled()) {
            for (DependencyNode child : node.getChildren()) {
                if (child.getRelocations().isEmpty()) continue;
                this.logger.warn("The artifact " + child.getRelocations().get(0) + " has been relocated to " + child.getDependency().getArtifact());
            }
        }
        if (this.logger.isDebugEnabled()) {
            node.accept((DependencyVisitor)new GraphLogger(project));
        }
        try {
            this.process(result, this.repoSystem.resolveDependencies(session, depRequest).getArtifactResults());
        }
        catch (org.gradle.mvn3.org.sonatype.aether.resolution.DependencyResolutionException e) {
            this.process(result, e.getResult().getArtifactResults());
            throw new DependencyResolutionException(result, "Could not resolve dependencies for project " + project.getId() + ": " + e.getMessage(), e);
        }
        return result;
    }

    private void process(DefaultDependencyResolutionResult result, Collection<ArtifactResult> results) {
        for (ArtifactResult ar : results) {
            DependencyNode node = ar.getRequest().getDependencyNode();
            if (ar.isResolved()) {
                result.addResolvedDependency(node.getDependency());
                continue;
            }
            result.setResolutionErrors(node.getDependency(), ar.getExceptions());
        }
    }

    class GraphLogger
    implements DependencyVisitor {
        private final MavenProject project;
        private String indent = "";
        private Map<String, org.gradle.mvn3.org.apache.maven.model.Dependency> managed;

        public GraphLogger(MavenProject project) {
            this.project = project;
        }

        public boolean visitEnter(DependencyNode node) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(this.indent);
            Dependency dep = node.getDependency();
            if (dep != null) {
                org.gradle.mvn3.org.sonatype.aether.artifact.Artifact art = dep.getArtifact();
                buffer.append(art);
                buffer.append(':').append(dep.getScope());
                if (node.getPremanagedScope() != null && !node.getPremanagedScope().equals(dep.getScope())) {
                    buffer.append(" (scope managed from ").append(node.getPremanagedScope());
                    this.appendManagementSource(buffer, art, "scope");
                    buffer.append(")");
                }
                if (node.getPremanagedVersion() != null && !node.getPremanagedVersion().equals(art.getVersion())) {
                    buffer.append(" (version managed from ").append(node.getPremanagedVersion());
                    this.appendManagementSource(buffer, art, "version");
                    buffer.append(")");
                }
            } else {
                buffer.append(this.project.getGroupId());
                buffer.append(':').append(this.project.getArtifactId());
                buffer.append(':').append(this.project.getPackaging());
                buffer.append(':').append(this.project.getVersion());
            }
            DefaultProjectDependenciesResolver.this.logger.debug(buffer.toString());
            this.indent = this.indent + "   ";
            return true;
        }

        public boolean visitLeave(DependencyNode node) {
            this.indent = this.indent.substring(0, this.indent.length() - 3);
            return true;
        }

        private void appendManagementSource(StringBuilder buffer, org.gradle.mvn3.org.sonatype.aether.artifact.Artifact artifact, String field) {
            InputSource source;
            InputLocation location;
            String key;
            org.gradle.mvn3.org.apache.maven.model.Dependency dependency;
            if (this.managed == null) {
                this.managed = new HashMap<String, org.gradle.mvn3.org.apache.maven.model.Dependency>();
                if (this.project.getDependencyManagement() != null) {
                    for (org.gradle.mvn3.org.apache.maven.model.Dependency dep : this.project.getDependencyManagement().getDependencies()) {
                        this.managed.put(dep.getManagementKey(), dep);
                    }
                }
            }
            if ((dependency = this.managed.get(key = ArtifacIdUtils.toVersionlessId((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getProperty("type", "jar"), (String)artifact.getClassifier()))) != null && (location = dependency.getLocation((Object)field)) != null && (source = location.getSource()) != null) {
                buffer.append(" by ").append(source.getModelId());
            }
        }
    }
}

