/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.lifecycle;

import org.gradle.mvn3.org.apache.maven.plugin.MojoExecution;

public class Schedule {
    private String phase;
    private String upstreamPhase;
    private String pluginKey;
    private String mojoGoal;
    private boolean mojoSynchronized;
    private boolean parallel;

    public Schedule() {
    }

    public Schedule(String phase, boolean mojoSynchronized, boolean parallel) {
        this.phase = phase;
        this.mojoSynchronized = mojoSynchronized;
        this.parallel = parallel;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public void setPluginKey(String pluginKey) {
        this.pluginKey = pluginKey;
    }

    public boolean isMojoSynchronized() {
        return this.mojoSynchronized;
    }

    public void setMojoSynchronized(boolean mojoSynchronized) {
        this.mojoSynchronized = mojoSynchronized;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public String getUpstreamPhase() {
        return this.upstreamPhase;
    }

    public void setUpstreamPhase(String upstreamPhase) {
        this.upstreamPhase = upstreamPhase;
    }

    public String getMojoGoal() {
        return this.mojoGoal;
    }

    public void setMojoGoal(String mojoGoal) {
        this.mojoGoal = mojoGoal;
    }

    public boolean hasUpstreamPhaseDefined() {
        return this.getUpstreamPhase() != null;
    }

    public boolean appliesTo(MojoExecution mojoExecution) {
        if (this.pluginKey == null && this.mojoGoal == null) {
            return false;
        }
        boolean pluginKeyMatches = this.pluginKey == null || this.pluginKey.equals(mojoExecution.getPlugin().getKey());
        boolean pluginGoalMatches = this.mojoGoal == null || this.mojoGoal.equals(mojoExecution.getGoal());
        return pluginKeyMatches && pluginGoalMatches;
    }

    public String toString() {
        return "Schedule{phase='" + this.phase + "', upstreamPhase='" + this.upstreamPhase + "', pluginKey='" + this.pluginKey + "', mojoGoal='" + this.mojoGoal + "', mojoSynchronized=" + this.mojoSynchronized + ", parallel=" + this.parallel + '}';
    }
}

