/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.configuration;

import org.gradle.mvn3.org.apache.maven.configuration.BeanConfigurationPathTranslator;
import org.gradle.mvn3.org.apache.maven.configuration.BeanConfigurationRequest;
import org.gradle.mvn3.org.apache.maven.configuration.BeanConfigurationValuePreprocessor;
import org.gradle.mvn3.org.apache.maven.model.Build;
import org.gradle.mvn3.org.apache.maven.model.Model;
import org.gradle.mvn3.org.apache.maven.model.Plugin;
import org.gradle.mvn3.org.apache.maven.model.PluginExecution;
import org.gradle.mvn3.org.apache.maven.model.PluginManagement;
import org.gradle.mvn3.org.codehaus.plexus.util.StringUtils;

public class DefaultBeanConfigurationRequest
implements BeanConfigurationRequest {
    private Object bean;
    private Object configuration;
    private String configurationElement;
    private ClassLoader classLoader;
    private BeanConfigurationValuePreprocessor valuePreprocessor;
    private BeanConfigurationPathTranslator pathTranslator;

    public Object getBean() {
        return this.bean;
    }

    public DefaultBeanConfigurationRequest setBean(Object bean) {
        this.bean = bean;
        return this;
    }

    public Object getConfiguration() {
        return this.configuration;
    }

    public String getConfigurationElement() {
        return this.configurationElement;
    }

    public DefaultBeanConfigurationRequest setConfiguration(Object configuration) {
        return this.setConfiguration(configuration, null);
    }

    public DefaultBeanConfigurationRequest setConfiguration(Object configuration, String element) {
        this.configuration = configuration;
        this.configurationElement = element;
        return this;
    }

    public DefaultBeanConfigurationRequest setConfiguration(Model model, String pluginGroupId, String pluginArtifactId, String pluginExecutionId) {
        Plugin plugin = this.findPlugin(model, pluginGroupId, pluginArtifactId);
        if (plugin != null) {
            if (StringUtils.isNotEmpty((String)pluginExecutionId)) {
                for (PluginExecution execution : plugin.getExecutions()) {
                    if (!pluginExecutionId.equals(execution.getId())) continue;
                    this.setConfiguration(execution.getConfiguration());
                    break;
                }
            } else {
                this.setConfiguration(plugin.getConfiguration());
            }
        }
        return this;
    }

    private Plugin findPlugin(Model model, String groupId, String artifactId) {
        Build build;
        if (StringUtils.isEmpty((String)groupId)) {
            throw new IllegalArgumentException("group id for plugin has not been specified");
        }
        if (StringUtils.isEmpty((String)artifactId)) {
            throw new IllegalArgumentException("artifact id for plugin has not been specified");
        }
        if (model != null && (build = model.getBuild()) != null) {
            for (Plugin plugin : build.getPlugins()) {
                if (!groupId.equals(plugin.getGroupId()) || !artifactId.equals(plugin.getArtifactId())) continue;
                return plugin;
            }
            PluginManagement mngt = build.getPluginManagement();
            if (mngt != null) {
                for (Plugin plugin : mngt.getPlugins()) {
                    if (!groupId.equals(plugin.getGroupId()) || !artifactId.equals(plugin.getArtifactId())) continue;
                    return plugin;
                }
            }
        }
        return null;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DefaultBeanConfigurationRequest setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public BeanConfigurationValuePreprocessor getValuePreprocessor() {
        return this.valuePreprocessor;
    }

    public DefaultBeanConfigurationRequest setValuePreprocessor(BeanConfigurationValuePreprocessor valuePreprocessor) {
        this.valuePreprocessor = valuePreprocessor;
        return this;
    }

    public BeanConfigurationPathTranslator getPathTranslator() {
        return this.pathTranslator;
    }

    public DefaultBeanConfigurationRequest setPathTranslator(BeanConfigurationPathTranslator pathTranslator) {
        this.pathTranslator = pathTranslator;
        return this;
    }
}

